/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.gui;

import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.common.container.AbstractModuleContainerMenu;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.RemoveConfiguredModuleItemAtMessage;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractConfigurableScannerModuleContainerScreen<TContainer extends AbstractModuleContainerMenu, TItem>
extends AbstractContainerScreen<TContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("scannable", "textures/gui/container/configurable_module.png");
    public static final int SLOTS_ORIGIN_X = 62;
    public static final int SLOTS_ORIGIN_Y = 20;
    public static final int SLOT_SIZE = 18;
    private final Component listCaption;
    private final Inventory inventory;

    public AbstractConfigurableScannerModuleContainerScreen(TContainer container, Inventory inventory, Component title, Component listCaption) {
        super(container, inventory, title);
        this.listCaption = listCaption;
        this.inventory = inventory;
        this.f_97727_ = 133;
        this.f_97730_ = 8;
        this.f_97731_ = 39;
    }

    private ItemStack getHeldItem() {
        return ((AbstractModuleContainerMenu)this.f_97732_).getPlayer().m_21120_(((AbstractModuleContainerMenu)this.f_97732_).getHand());
    }

    protected abstract List<TItem> getConfiguredItems(ItemStack var1);

    protected abstract Component getItemName(TItem var1);

    protected abstract void renderConfiguredItem(GuiGraphics var1, TItem var2, int var3, int var4);

    protected void configureItemAt(ItemStack stack, int slot, ItemStack value) {
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        ItemStack stack = this.getHeldItem();
        List<TItem> items = this.getConfiguredItems(stack);
        for (int slot = 0; slot < Math.min(items.size(), 5); ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (!this.m_6774_(x, 20, 16, 16, mouseX, mouseY)) continue;
            TItem item = items.get(slot);
            graphics.m_280557_(this.f_96547_, this.getItemName(item), mouseX, mouseY);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        graphics.m_280614_(this.f_96547_, this.listCaption, 8, 23, 0x404040, false);
        ItemStack stack = this.getHeldItem();
        List<TItem> items = this.getConfiguredItems(stack);
        for (int slot = 0; slot < 5; ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (this.m_6774_(x, 20, 16, 16, mouseX, mouseY)) {
                AbstractConfigurableScannerModuleContainerScreen.m_280359_((GuiGraphics)graphics, (int)x, (int)20, (int)400);
            }
            if (slot >= items.size()) continue;
            TItem item = items.get(slot);
            this.renderConfiguredItem(graphics, item, x, 20);
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(BACKGROUND, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (int slot = 0; slot < 5; ++slot) {
            int x = 62 + slot * 18;
            int y = 20;
            if (!this.m_6774_(x, 20, 18, 18, mouseX, mouseY)) continue;
            ItemStack heldItemStack = ((AbstractModuleContainerMenu)this.f_97732_).m_142621_();
            if (!heldItemStack.m_41619_()) {
                this.configureItemAt(this.getHeldItem(), slot, heldItemStack);
            } else {
                Network.sendToServer(new RemoveConfiguredModuleItemAtMessage(((AbstractModuleContainerMenu)this.f_97732_).f_38840_, slot));
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6597_(@Nullable Slot slot, int slotId, int mouseButton, ClickType type) {
        if (slot != null) {
            ItemStack heldItem = this.getHeldItem();
            if (slot.m_7993_() == heldItem) {
                return;
            }
            if (type == ClickType.SWAP && this.inventory.m_8020_(mouseButton) == heldItem) {
                return;
            }
        }
        super.m_6597_(slot, slotId, mouseButton, type);
    }
}

