/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.cooking;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoBlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmokingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.IAutoCookingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;

public class AutoCookingUpgradeWrapper<W extends AutoCookingUpgradeWrapper<W, U, R>, U extends UpgradeItemBase<W>, R extends AbstractCookingRecipe>
extends UpgradeWrapperBase<W, U>
implements ITickableUpgrade,
ICookingUpgrade<R> {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    private static final int NO_INVENTORY_SPACE_COOLDOWN = 60;
    private final FilterLogic inputFilterLogic;
    private final FilterLogic fuelFilterLogic;
    private final CookingLogic<R> cookingLogic;
    private final Predicate<ItemStack> isValidInput;
    private final Predicate<ItemStack> isValidFuel;
    private final RecipeType<R> recipeType;
    private int outputCooldown = 0;
    private int fuelCooldown = 0;
    private int inputCooldown = 0;
    private final AutoCookingUpgradeConfig autoCookingUpgradeConfig;

    public AutoCookingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler, RecipeType<R> recipeType, float burnTimeModifier) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.recipeType = recipeType;
        this.autoCookingUpgradeConfig = ((IAutoCookingUpgradeItem)((Object)this.upgradeItem)).getAutoCookingUpgradeConfig();
        this.inputFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)this.autoCookingUpgradeConfig.inputFilterSlots.get(), s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent(), "inputFilter");
        this.fuelFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)this.autoCookingUpgradeConfig.fuelFilterSlots.get(), s -> ForgeHooks.getBurnTime((ItemStack)s, (RecipeType)recipeType) > 0, "fuelFilter");
        this.fuelFilterLogic.setAllowByDefault(true);
        this.fuelFilterLogic.setEmptyAllowListMatchesEverything();
        this.isValidInput = s -> RecipeHelper.getCookingRecipe(s, recipeType).isPresent() && this.inputFilterLogic.matchesFilter((ItemStack)s);
        this.isValidFuel = s -> ForgeHooks.getBurnTime((ItemStack)s, (RecipeType)recipeType) > 0 && this.fuelFilterLogic.matchesFilter((ItemStack)s);
        this.cookingLogic = new CookingLogic<R>(upgrade, upgradeSaveHandler, this.isValidFuel, this.isValidInput, this.autoCookingUpgradeConfig, recipeType, burnTimeModifier);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.pauseAndRemoveRenderInfo();
        }
        super.setEnabled(enabled);
    }

    private void pauseAndRemoveRenderInfo() {
        this.cookingLogic.pause();
        RenderInfo renderInfo = this.storageWrapper.getRenderInfo();
        renderInfo.removeUpgradeRenderData(CookingUpgradeRenderData.TYPE);
    }

    @Override
    public void onBeforeRemoved() {
        this.pauseAndRemoveRenderInfo();
    }

    private void tryPushingOutput() {
        if (this.outputCooldown > 0) {
            --this.outputCooldown;
            return;
        }
        ItemStack output = this.cookingLogic.getCookOutput();
        ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        if (!output.m_41619_() && inventory.insertItem(output, true).m_41613_() < output.m_41613_()) {
            ItemStack ret = inventory.insertItem(output, false);
            this.cookingLogic.getCookingInventory().extractItem(2, output.m_41613_() - ret.m_41613_(), false);
        } else {
            this.outputCooldown = 60;
        }
        ItemStack fuel = this.cookingLogic.getFuel();
        if (!fuel.m_41619_() && ForgeHooks.getBurnTime((ItemStack)fuel, this.recipeType) <= 0 && inventory.insertItem(fuel, true).m_41613_() < fuel.m_41613_()) {
            ItemStack ret = inventory.insertItem(fuel, false);
            this.cookingLogic.getCookingInventory().extractItem(1, fuel.m_41613_() - ret.m_41613_(), false);
        }
    }

    @Override
    public void tick(@Nullable LivingEntity entity, Level world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        this.tryPushingOutput();
        this.tryPullingFuel();
        this.tryPullingInput();
        if (!this.cookingLogic.tick(world) && this.outputCooldown <= 0 && this.fuelCooldown <= 0 && this.inputCooldown <= 0) {
            this.setCooldown(world, 10);
        }
        boolean isBurning = this.cookingLogic.isBurning(world);
        RenderInfo renderInfo = this.storageWrapper.getRenderInfo();
        if (renderInfo.getUpgradeRenderData(CookingUpgradeRenderData.TYPE).map(CookingUpgradeRenderData::isBurning).orElse(false) != isBurning) {
            if (isBurning) {
                renderInfo.setUpgradeRenderData(CookingUpgradeRenderData.TYPE, new CookingUpgradeRenderData(true));
            } else {
                renderInfo.removeUpgradeRenderData(CookingUpgradeRenderData.TYPE);
            }
        }
    }

    private void tryPullingInput() {
        if (this.inputCooldown > 0) {
            --this.inputCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.cookingLogic.getCookInput(), this.cookingLogic::setCookInput, this.isValidInput)) {
            this.inputCooldown = 60;
        }
    }

    private void tryPullingFuel() {
        if (this.fuelCooldown > 0) {
            --this.fuelCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.cookingLogic.getFuel(), this.cookingLogic::setFuel, this.isValidFuel)) {
            this.fuelCooldown = 60;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryPullingGetUnsucessful(ItemStack stack, Consumer<ItemStack> setSlot, Predicate<ItemStack> isItemValid) {
        ItemStack toExtract;
        ITrackedContentsItemHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        if (stack.m_41619_()) {
            AtomicReference<ItemStack> ret = new AtomicReference<ItemStack>(ItemStack.f_41583_);
            InventoryHelper.iterate((IItemHandler)inventory, (slot, st) -> {
                if (isItemValid.test((ItemStack)st)) {
                    ret.set(st.m_41777_());
                }
            }, () -> !((ItemStack)ret.get()).m_41619_());
            if (ret.get().m_41619_()) return true;
            toExtract = ret.get();
            toExtract.m_41764_(toExtract.m_41741_());
        } else {
            if (stack.m_41613_() == stack.m_41741_() || !isItemValid.test(stack)) {
                return true;
            }
            toExtract = stack.m_41777_();
            toExtract.m_41764_(stack.m_41741_() - stack.m_41613_());
        }
        if (InventoryHelper.extractFromInventory(toExtract, (IItemHandler)inventory, true).m_41613_() <= 0) {
            return true;
        }
        ItemStack toSet = InventoryHelper.extractFromInventory(toExtract, (IItemHandler)inventory, false);
        toSet.m_41769_(stack.m_41613_());
        setSlot.accept(toSet);
        return false;
    }

    @Override
    public CookingLogic<R> getCookingLogic() {
        return this.cookingLogic;
    }

    public FilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public FilterLogic getFuelFilterLogic() {
        return this.fuelFilterLogic;
    }

    public static class AutoBlastingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoBlastingUpgradeWrapper, AutoBlastingUpgradeItem, BlastingRecipe> {
        public AutoBlastingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.f_44109_, 0.5f);
        }
    }

    public static class AutoSmokingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoSmokingUpgradeWrapper, AutoSmokingUpgradeItem, SmokingRecipe> {
        public AutoSmokingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.f_44110_, 0.5f);
        }
    }

    public static class AutoSmeltingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoSmeltingUpgradeWrapper, AutoSmeltingUpgradeItem, SmeltingRecipe> {
        public AutoSmeltingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.f_44108_, 1.0f);
        }
    }
}

