/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedcore.common.CommonEventHandler;
import net.p3pp3rf1y.sophisticatedcore.data.DataGenerators;
import net.p3pp3rf1y.sophisticatedcore.init.ModCompat;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.DatapackSettingsTemplateManager;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sophisticatedcore")
public class SophisticatedCore {
    public static final String MOD_ID = "sophisticatedcore";
    public static final Logger LOGGER = LogManager.getLogger((String)"sophisticatedcore");
    public final CommonEventHandler commonEventHandler = new CommonEventHandler();

    public SophisticatedCore() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        this.commonEventHandler.registerHandlers();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEventHandler.registerHandlers();
        }
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(SophisticatedCore::setup);
        modBus.addListener(DataGenerators::gatherData);
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        eventBus.addListener(SophisticatedCore::serverStarted);
        eventBus.addListener(SophisticatedCore::onResourceReload);
    }

    private static void serverStarted(ServerStartedEvent event) {
        ServerLevel world = event.getServer().m_129880_(Level.f_46428_);
        if (world != null) {
            RecipeHelper.setWorld((Level)world);
        }
    }

    private static void setup(FMLCommonSetupEvent event) {
        PacketHandler.INSTANCE.init();
        ModCompat.initCompats();
    }

    private static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)DatapackSettingsTemplateManager.Loader.INSTANCE);
    }

    public static ResourceLocation getRL(String regName) {
        return new ResourceLocation(SophisticatedCore.getRegistryName(regName));
    }

    public static String getRegistryName(String regName) {
        return "sophisticatedcore:" + regName;
    }
}

