/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.logistics.filter.AbstractFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreenPacket;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractFilterScreen<F extends AbstractFilterMenu>
extends AbstractSimiContainerScreen<F> {
    protected AllGuiTextures background;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;

    protected AbstractFilterScreen(F menu, Inventory inv, Component title, AllGuiTextures background) {
        super(menu, inv, title);
        this.background = background;
    }

    @Override
    protected void m_7856_() {
        this.setWindowSize(Math.max(this.background.width, AllGuiTextures.PLAYER_INVENTORY.width), this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.resetButton = new IconButton(x + this.background.width - 62, y + this.background.height - 24, AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((AbstractFilterMenu)this.f_97732_).clearContents();
            this.contentsCleared();
            ((AbstractFilterMenu)this.f_97732_).sendClearPacket();
        });
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.m_142416_(this.resetButton);
        this.m_142416_(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width, y + this.background.height - 40, 80, 48));
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.f_97736_ + this.background.height + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.background.render(graphics, x, y);
        graphics.m_280614_(this.f_96547_, this.f_96539_, x + (this.background.width - 8) / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, y + 4, AllItems.FILTER.isIn((ItemStack)((AbstractFilterMenu)this.f_97732_).contentHolder) ? 0x303030 : 5841956, false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((AbstractFilterMenu)this.f_97732_).contentHolder).at(x + this.background.width + 8, y + this.background.height - 52, -200.0f)).scale(4.0).render(graphics);
    }

    @Override
    protected void m_181908_() {
        if (!((AbstractFilterMenu)this.f_97732_).player.m_21205_().equals((ItemStack)((AbstractFilterMenu)this.f_97732_).contentHolder, false)) {
            ((AbstractFilterMenu)this.f_97732_).player.m_6915_();
        }
        super.m_181908_();
        this.handleTooltips();
        this.handleIndicators();
    }

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            if (button.getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((Component)TooltipHelper.holdShift(TooltipHelper.Palette.YELLOW, AbstractFilterScreen.m_96638_()));
        }
        if (AbstractFilterScreen.m_96638_()) {
            List<MutableComponent> tooltipDescriptions = this.getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); ++i) {
                this.fillToolTip(tooltipButtons.get(i), (Component)tooltipDescriptions.get(i));
            }
        }
    }

    public void handleIndicators() {
        for (IconButton button : this.getTooltipButtons()) {
            button.f_93623_ = this.isButtonEnabled(button);
        }
        for (Indicator indicator : this.getIndicators()) {
            indicator.state = this.isIndicatorOn(indicator) ? Indicator.State.ON : Indicator.State.OFF;
        }
    }

    protected abstract boolean isButtonEnabled(IconButton var1);

    protected abstract boolean isIndicatorOn(Indicator var1);

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<MutableComponent> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    protected List<Indicator> getIndicators() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, Component tooltip) {
        if (!button.m_198029_()) {
            return;
        }
        List<Component> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent(tooltip, TooltipHelper.Palette.ALL_GRAY));
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        AllPackets.getChannel().sendToServer((Object)new FilterScreenPacket(option));
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

