/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.copycat;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.copycat.WaterloggedCopycatBlock;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.foundation.utility.VoxelShaper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CopycatStepBlock
extends WaterloggedCopycatBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public CopycatStepBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(HALF, (Comparable)Half.BOTTOM)).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (!player.m_6144_() && player.m_36326_()) {
            ItemStack heldItem = player.m_21120_(hand);
            IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
            if (helper.matchesItem(heldItem)) {
                return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
            }
        }
        return super.m_6227_(state, world, pos, player, hand, ray);
    }

    @Override
    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        BlockState toState = reader.m_8055_(toPos);
        if (!toState.m_60713_((Block)this)) {
            return true;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos diff = fromPos.m_121996_((Vec3i)toPos);
        int coord = facing.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        Half half = (Half)state.m_61143_(HALF);
        if (half != toState.m_61143_(HALF)) {
            return diff.m_123342_() == 0;
        }
        return facing == ((Direction)toState.m_61143_((Property)FACING)).m_122424_() && (coord == 0 || coord == facing.m_122421_().m_122540_());
    }

    @Override
    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState toState = reader.m_8055_(toPos);
        BlockPos diff = fromPos.m_121996_((Vec3i)toPos);
        if (fromPos.equals((Object)toPos.m_121945_(facing))) {
            return false;
        }
        if (!toState.m_60713_((Block)this)) {
            return false;
        }
        if (diff.m_123342_() != 0) {
            return CopycatStepBlock.isOccluded(toState, state, diff.m_123342_() > 0 ? Direction.UP : Direction.DOWN);
        }
        if (CopycatStepBlock.isOccluded(state, toState, facing)) {
            return true;
        }
        int coord = facing.m_122434_().m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
        return state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) == toState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)) && coord == 0;
    }

    @Override
    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        if (face.m_122434_() == Direction.Axis.Y) {
            return state.m_61143_(HALF) == Half.TOP == (face == Direction.UP);
        }
        return state.m_61143_((Property)FACING) == face;
    }

    @Override
    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return this.canFaceBeOccluded(state, face.m_122424_());
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = (BlockState)super.m_5573_(pContext).m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
        Direction direction = pContext.m_43719_();
        if (direction == Direction.UP) {
            return stateForPlacement;
        }
        if (direction == Direction.DOWN || pContext.m_43720_().f_82480_ - (double)pContext.m_8083_().m_123342_() > 0.5) {
            return (BlockState)stateForPlacement.m_61124_(HALF, (Comparable)Half.TOP);
        }
        return stateForPlacement;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)pBuilder.m_61104_(new Property[]{HALF, FACING}));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShaper voxelShaper = pState.m_61143_(HALF) == Half.BOTTOM ? AllShapes.STEP_BOTTOM : AllShapes.STEP_TOP;
        return voxelShaper.get((Direction)pState.m_61143_((Property)FACING));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.m_60713_((Block)this) == neighborState.m_60713_((Block)this) && CopycatStepBlock.getMaterial(level, pos).m_60719_(CopycatStepBlock.getMaterial(level, pos.m_121945_(dir)), dir.m_122424_())) {
            return CopycatStepBlock.isOccluded(state, neighborState, dir);
        }
        return false;
    }

    public static boolean isOccluded(BlockState state, BlockState other, Direction pDirection) {
        boolean vertical;
        state = (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        other = (BlockState)other.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        Half half = (Half)state.m_61143_(HALF);
        boolean bl = vertical = pDirection.m_122434_() == Direction.Axis.Y;
        if (half != other.m_61143_(HALF)) {
            return vertical && pDirection == Direction.UP == (half == Half.TOP);
        }
        if (vertical) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.m_122424_() == other.m_61143_((Property)FACING) && pDirection == facing) {
            return true;
        }
        if (other.m_61143_((Property)FACING) != facing) {
            return false;
        }
        return pDirection.m_122434_() != facing.m_122434_();
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    private static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(arg_0 -> AllBlocks.COPYCAT_STEP.has(arg_0), state -> ((Direction)state.m_61143_((Property)FACING)).m_122427_().m_122434_(), FACING);
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.COPYCAT_STEP.isIn(arg_0);
        }
    }
}

