/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedItemDrain;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@ParametersAreNonnullByDefault
public class ItemDrainCategory
extends CreateRecipeCategory<EmptyingRecipe> {
    private final AnimatedItemDrain drain = new AnimatedItemDrain();

    public ItemDrainCategory(CreateRecipeCategory.Info<EmptyingRecipe> info) {
        super(info);
    }

    public static void consumeRecipes(Consumer<EmptyingRecipe> consumer, IIngredientManager ingredientManager) {
        for (ItemStack stack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            if (stack.m_41720_() instanceof PotionItem) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                Ingredient potion = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
                consumer.accept(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("potions")).withItemIngredients(potion).withFluidOutputs(fluidFromPotionItem).withSingleItemOutput(new ItemStack((ItemLike)Items.f_42590_)).build());
                continue;
            }
            LazyOptional capability = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (!capability.isPresent()) continue;
            ItemStack copy = stack.m_41777_();
            capability = copy.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            IFluidHandlerItem handler = (IFluidHandlerItem)capability.orElse(null);
            FluidStack extracted = handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            ItemStack result = handler.getContainer();
            if (extracted.isEmpty() || result.m_41619_()) continue;
            Ingredient ingredient = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            ResourceLocation itemName = RegisteredObjects.getKeyOrThrow(stack.m_41720_());
            ResourceLocation fluidName = RegisteredObjects.getKeyOrThrow(extracted.getFluid());
            consumer.accept(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("empty_" + itemName.m_135827_() + "_" + itemName.m_135815_() + "_of_" + fluidName.m_135827_() + "_" + fluidName.m_135815_())).withItemIngredients(ingredient).withFluidOutputs(extracted).withSingleItemOutput(result).build());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EmptyingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 8).setBackground(ItemDrainCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 8).setBackground(ItemDrainCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)ItemDrainCategory.withImprovedVisibility(recipe.getResultingFluid()))).addTooltipCallback(ItemDrainCategory.addFluidTooltip(recipe.getResultingFluid().getAmount()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 27).setBackground(ItemDrainCategory.getRenderedSlot(), -1, -1).addItemStack(ItemDrainCategory.getResultItem(recipe));
    }

    public void draw(EmptyingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 37);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 73, 4);
        this.drain.withFluid(recipe.getResultingFluid()).draw(graphics, this.getBackground().getWidth() / 2 - 13, 40);
    }
}

