/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.service;

import de.maxhenkel.voicechat.Voicechat;
import java.lang.reflect.InvocationTargetException;
import java.util.ServiceLoader;
import javax.annotation.Nullable;

public class Service {
    public static <T> T get(Class<T> serviceClass) {
        return (T)ServiceLoader.load(serviceClass).findFirst().orElseGet(() -> {
            Voicechat.LOGGER.warn("Failed to load service {} with ServiceLoader", serviceClass.getSimpleName());
            try {
                return Service.loadFallback(serviceClass);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load service %s".formatted(serviceClass.getSimpleName()), e);
            }
        });
    }

    private static <T> T loadFallback(Class<T> serviceClass) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> fallbackClass = Service.loadFallbackClass(serviceClass);
        if (!serviceClass.isAssignableFrom(fallbackClass)) {
            throw new ClassNotFoundException("Class %s is not an instance of %s".formatted(fallbackClass.getSimpleName(), serviceClass.getSimpleName()));
        }
        return (T)fallbackClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static Class<?> loadFallbackClass(Class<?> serviceClass) throws ClassNotFoundException {
        Class<?> implClass = Service.loadClassWithPrefix(serviceClass, "Fabric");
        if (implClass != null) {
            return implClass;
        }
        implClass = Service.loadClassWithPrefix(serviceClass, "Forge");
        if (implClass != null) {
            return implClass;
        }
        implClass = Service.loadClassWithPrefix(serviceClass, "Quilt");
        if (implClass != null) {
            return implClass;
        }
        throw new ClassNotFoundException("Implementation of %s not found in package %s".formatted(serviceClass.getSimpleName(), serviceClass.getPackageName()));
    }

    @Nullable
    private static Class<?> loadClassWithPrefix(Class<?> serviceClass, String prefix) {
        try {
            return Class.forName(serviceClass.getPackageName() + "." + prefix + serviceClass.getSimpleName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

