/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.worldgen.feature.tree;

import biomesoplenty.common.util.biome.GeneratorUtil;
import biomesoplenty.common.worldgen.feature.configurations.BasicTreeConfiguration;
import biomesoplenty.common.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;

public class BushTreeFeature
extends BOPTreeFeature<BasicTreeConfiguration> {
    public BushTreeFeature(Codec<BasicTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean m_225257_(WorldGenLevel world, RandomSource random, BlockPos startPos, BiConsumer<BlockPos, BlockState> roots, BiConsumer<BlockPos, BlockState> logs, FoliagePlacer.FoliageSetter leaves, TreeConfiguration configBase) {
        BasicTreeConfiguration config = (BasicTreeConfiguration)configBase;
        while (startPos.m_123342_() >= world.m_141937_() + 1 && (world.m_46859_(startPos) || world.m_8055_(startPos).m_60795_())) {
            startPos = startPos.m_7495_();
        }
        if (!this.canReplace((LevelAccessor)world, startPos.m_7494_())) {
            return false;
        }
        int height = GeneratorUtil.nextIntBetween(random, config.minHeight, config.maxHeight);
        BlockPos pos = startPos.m_7494_();
        for (int y = 0; y < height; ++y) {
            if (height - y > 1) {
                this.placeLog((LevelAccessor)world, pos.m_7918_(0, y, 0), logs, config);
            }
            int leavesRadius = height - y > 1 ? 2 : 1;
            for (int x = -leavesRadius; x <= leavesRadius; ++x) {
                for (int z = -leavesRadius; z <= leavesRadius; ++z) {
                    if (Math.abs(x) >= leavesRadius && Math.abs(z) >= leavesRadius && random.m_188503_(2) == 0) continue;
                    if (config.altFoliageProvider.m_213972_(random, pos) != Blocks.f_50016_.m_49966_()) {
                        if (random.m_188503_(4) == 0) {
                            this.placeAltLeaves((LevelAccessor)world, pos.m_7918_(x, y, z), leaves, config);
                            continue;
                        }
                        this.placeLeaves((LevelAccessor)world, pos.m_7918_(x, y, z), leaves, config);
                        continue;
                    }
                    this.placeLeaves((LevelAccessor)world, pos.m_7918_(x, y, z), leaves, config);
                }
            }
        }
        return true;
    }
}

