/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="condor")
public class RitualCondor
extends Ritual {
    public static final String FLIGHT_RANGE = "flightRange";

    public RitualCondor() {
        super("ritualCondor", 0, 1000000, "ritual.bloodmagic.condorRitual");
        this.addBlockRange(FLIGHT_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, 0, -10), new BlockPos(10, 30, 10)));
        this.setMaximumVolumeAndDistanceOfRange(FLIGHT_RANGE, 0, 100, 200);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        AABB aabb = masterRitualStone.getBlockRange(FLIGHT_RANGE).getAABB(masterRitualStone.getMasterBlockPos());
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        List playerEntitys = world.m_45976_(Player.class, aabb);
        int entityCount = playerEntitys.size();
        if (currentEssence < this.getRefreshCost() * entityCount) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        entityCount = 0;
        for (Player player : playerEntitys) {
            player.m_7292_(new MobEffectInstance((MobEffect)BloodMagicPotions.FLIGHT.get(), 20, 0, true, false));
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * entityCount));
    }

    @Override
    public int getRefreshTime() {
        return 10;
    }

    @Override
    public int getRefreshCost() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        int i;
        this.addParallelRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 3, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 3, 0, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 3, 4, 0, EnumRuneType.WATER);
        this.addParallelRunes(components, 1, 1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 2, 1, EnumRuneType.BLANK);
        this.addParallelRunes(components, 4, 1, EnumRuneType.BLANK);
        this.addParallelRunes(components, 5, 1, EnumRuneType.AIR);
        this.addParallelRunes(components, 5, 0, EnumRuneType.DUSK);
        for (i = 2; i <= 4; ++i) {
            this.addParallelRunes(components, i, 2, EnumRuneType.EARTH);
        }
        this.addOffsetRunes(components, 2, 1, 4, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 4, EnumRuneType.AIR);
        this.addCornerRunes(components, 4, 2, EnumRuneType.FIRE);
        for (i = -1; i <= 1; ++i) {
            this.addOffsetRunes(components, 3, i, 4, EnumRuneType.EARTH);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCondor();
    }
}

