/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;

public abstract class AreaDescriptor
implements Iterator<BlockPos> {
    public List<BlockPos> getContainedPositions(BlockPos pos) {
        return new ArrayList<BlockPos>();
    }

    public AABB getAABB(BlockPos pos) {
        return null;
    }

    public abstract void resetCache();

    public abstract boolean isWithinArea(BlockPos var1);

    public abstract void resetIterator();

    public void readFromNBT(CompoundTag tag) {
    }

    public void writeToNBT(CompoundTag tag) {
    }

    public abstract AreaDescriptor copy();

    public abstract int getVolumeForOffsets(BlockPos var1, BlockPos var2);

    public abstract boolean isWithinRange(BlockPos var1, BlockPos var2, int var3, int var4);

    public abstract int getVolume();

    public abstract int getHeight();

    public abstract boolean isWithinRange(int var1, int var2);

    public abstract void modifyAreaByBlockPositions(BlockPos var1, BlockPos var2);

    public abstract boolean intersects(AreaDescriptor var1);

    public abstract AreaDescriptor offset(BlockPos var1);

    public abstract AreaDescriptor rotateDescriptor(StructurePlaceSettings var1);

    public static class Cross
    extends AreaDescriptor {
        private ArrayList<BlockPos> blockPosCache;
        private BlockPos cachedPosition;
        private BlockPos centerPos;
        private int size;
        private boolean cache = true;

        public Cross(BlockPos center, int size) {
            this.centerPos = center;
            this.size = size;
            this.blockPosCache = new ArrayList();
        }

        public Cross(Cross cross) {
            this(cross.centerPos, cross.size);
        }

        @Override
        public Cross copy() {
            return new Cross(this);
        }

        @Override
        public int getHeight() {
            return this.size * 2 + 1;
        }

        @Override
        public List<BlockPos> getContainedPositions(BlockPos pos) {
            if (!this.cache || !pos.equals((Object)this.cachedPosition) || this.blockPosCache.isEmpty()) {
                this.resetCache();
                this.blockPosCache.add(this.centerPos.m_121955_((Vec3i)pos));
                for (int i = 1; i <= this.size; ++i) {
                    this.blockPosCache.add(this.centerPos.m_121955_((Vec3i)pos).m_7918_(i, 0, 0));
                    this.blockPosCache.add(this.centerPos.m_121955_((Vec3i)pos).m_7918_(0, 0, i));
                    this.blockPosCache.add(this.centerPos.m_121955_((Vec3i)pos).m_7918_(-i, 0, 0));
                    this.blockPosCache.add(this.centerPos.m_121955_((Vec3i)pos).m_7918_(0, 0, -i));
                }
            }
            this.cachedPosition = pos;
            return Collections.unmodifiableList(this.blockPosCache);
        }

        @Override
        public void resetCache() {
            this.blockPosCache = new ArrayList();
        }

        @Override
        public boolean isWithinArea(BlockPos pos) {
            return this.blockPosCache.contains(pos);
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public BlockPos next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void resetIterator() {
        }

        @Override
        public void modifyAreaByBlockPositions(BlockPos pos1, BlockPos pos2) {
        }

        @Override
        public int getVolumeForOffsets(BlockPos pos1, BlockPos pos2) {
            return 0;
        }

        @Override
        public boolean isWithinRange(BlockPos offset1, BlockPos offset2, int verticalLimit, int horizontalLimit) {
            return false;
        }

        @Override
        public int getVolume() {
            return 0;
        }

        @Override
        public boolean isWithinRange(int verticalLimit, int horizontalLimit) {
            return false;
        }

        @Override
        public boolean intersects(AreaDescriptor descriptor) {
            return false;
        }

        @Override
        public AreaDescriptor offset(BlockPos offset) {
            return new Cross(this.centerPos.m_121955_((Vec3i)offset), this.size);
        }

        @Override
        public AreaDescriptor rotateDescriptor(StructurePlaceSettings settings) {
            return this;
        }
    }

    public static class HemiSphere
    extends AreaDescriptor {
        private BlockPos minimumOffset;
        private int radius;
        private ArrayList<BlockPos> blockPosCache;
        private BlockPos cachedPosition;
        private boolean cache = true;

        public HemiSphere(BlockPos minimumOffset, int radius) {
            this.setRadius(minimumOffset, radius);
        }

        public HemiSphere(HemiSphere hemiSphere) {
            this(hemiSphere.minimumOffset, hemiSphere.radius);
        }

        @Override
        public HemiSphere copy() {
            return new HemiSphere(this);
        }

        public void setRadius(BlockPos minimumOffset, int radius) {
            this.minimumOffset = new BlockPos(Math.min(minimumOffset.m_123341_(), minimumOffset.m_123341_()), Math.min(minimumOffset.m_123342_(), minimumOffset.m_123342_()), Math.min(minimumOffset.m_123343_(), minimumOffset.m_123343_()));
            this.radius = radius;
            this.blockPosCache = new ArrayList();
        }

        @Override
        public int getHeight() {
            return this.radius * 2;
        }

        @Override
        public List<BlockPos> getContainedPositions(BlockPos pos) {
            if (!this.cache || !pos.equals((Object)this.cachedPosition) || this.blockPosCache.isEmpty()) {
                ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
                int j = this.minimumOffset.m_123342_();
                int k = -this.radius;
                for (int i = -this.radius; i <= this.radius; ++i) {
                    while (j <= this.radius) {
                        while (k <= this.radius) {
                            if ((float)(i * i + j * j + k * k) >= ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f)) {
                                ++k;
                                continue;
                            }
                            posList.add(pos.m_7918_(i, j, k));
                            ++k;
                        }
                        k = -this.radius;
                        ++j;
                    }
                    j = this.minimumOffset.m_123342_();
                }
                this.blockPosCache = posList;
                this.cachedPosition = pos;
            }
            return Collections.unmodifiableList(this.blockPosCache);
        }

        @Override
        public AABB getAABB(BlockPos pos) {
            return null;
        }

        @Override
        public void resetCache() {
            this.blockPosCache = new ArrayList();
        }

        @Override
        public boolean isWithinArea(BlockPos pos) {
            return this.blockPosCache.contains(pos);
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public BlockPos next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void resetIterator() {
        }

        @Override
        public void modifyAreaByBlockPositions(BlockPos pos1, BlockPos pos2) {
        }

        @Override
        public int getVolumeForOffsets(BlockPos pos1, BlockPos pos2) {
            return 0;
        }

        @Override
        public boolean isWithinRange(BlockPos offset1, BlockPos offset2, int verticalLimit, int horizontalLimit) {
            return false;
        }

        @Override
        public int getVolume() {
            return 0;
        }

        @Override
        public boolean isWithinRange(int verticalLimit, int horizontalLimit) {
            return false;
        }

        @Override
        public boolean intersects(AreaDescriptor descriptor) {
            return false;
        }

        @Override
        public AreaDescriptor offset(BlockPos offset) {
            return new HemiSphere(this.minimumOffset.m_121955_((Vec3i)offset), this.radius);
        }

        @Override
        public AreaDescriptor rotateDescriptor(StructurePlaceSettings settings) {
            return this;
        }
    }

    public static class Rectangle
    extends AreaDescriptor {
        protected BlockPos minimumOffset;
        protected BlockPos maximumOffset;
        private BlockPos currentPosition;
        private ArrayList<BlockPos> blockPosCache;
        private BlockPos cachedPosition;
        private boolean cache = true;

        public Rectangle(BlockPos minimumOffset, BlockPos maximumOffset) {
            this.setOffsets(minimumOffset, maximumOffset);
        }

        public Rectangle(BlockPos minimumOffset, int sizeX, int sizeY, int sizeZ) {
            this(minimumOffset, minimumOffset.m_7918_(sizeX, sizeY, sizeZ));
        }

        public Rectangle(BlockPos minimumOffset, int size) {
            this(minimumOffset, size, size, size);
        }

        public Rectangle(Rectangle rectangle) {
            this(rectangle.minimumOffset, rectangle.maximumOffset);
        }

        @Override
        public Rectangle copy() {
            return new Rectangle(this);
        }

        @Override
        public List<BlockPos> getContainedPositions(BlockPos pos) {
            if (!this.cache || !pos.equals((Object)this.cachedPosition) || this.blockPosCache.isEmpty()) {
                ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
                for (int j = this.minimumOffset.m_123342_(); j < this.maximumOffset.m_123342_(); ++j) {
                    for (int i = this.minimumOffset.m_123341_(); i < this.maximumOffset.m_123341_(); ++i) {
                        for (int k = this.minimumOffset.m_123343_(); k < this.maximumOffset.m_123343_(); ++k) {
                            posList.add(pos.m_7918_(i, j, k));
                        }
                    }
                }
                this.blockPosCache = posList;
                this.cachedPosition = pos;
            }
            return Collections.unmodifiableList(this.blockPosCache);
        }

        @Override
        public AABB getAABB(BlockPos pos) {
            AABB tempAABB = new AABB(this.minimumOffset, this.maximumOffset);
            return tempAABB.m_82386_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }

        @Override
        public int getHeight() {
            return this.maximumOffset.m_123342_() - this.minimumOffset.m_123342_();
        }

        public BlockPos getMinimumOffset() {
            return this.minimumOffset;
        }

        public BlockPos getMaximumOffset() {
            return this.maximumOffset;
        }

        public void setOffsets(BlockPos offset1, BlockPos offset2) {
            this.minimumOffset = new BlockPos(Math.min(offset1.m_123341_(), offset2.m_123341_()), Math.min(offset1.m_123342_(), offset2.m_123342_()), Math.min(offset1.m_123343_(), offset2.m_123343_()));
            this.maximumOffset = new BlockPos(Math.max(offset1.m_123341_(), offset2.m_123341_()), Math.max(offset1.m_123342_(), offset2.m_123342_()), Math.max(offset1.m_123343_(), offset2.m_123343_()));
            this.blockPosCache = new ArrayList();
        }

        @Override
        public void resetCache() {
            this.blockPosCache = new ArrayList();
        }

        @Override
        public boolean isWithinArea(BlockPos pos) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return x >= this.minimumOffset.m_123341_() && x < this.maximumOffset.m_123341_() && y >= this.minimumOffset.m_123342_() && y < this.maximumOffset.m_123342_() && z >= this.minimumOffset.m_123343_() && z < this.maximumOffset.m_123343_();
        }

        @Override
        public boolean hasNext() {
            return this.currentPosition == null || this.currentPosition.m_123341_() + 1 != this.maximumOffset.m_123341_() || this.currentPosition.m_123342_() + 1 != this.maximumOffset.m_123342_() || this.currentPosition.m_123343_() + 1 != this.maximumOffset.m_123343_();
        }

        @Override
        public BlockPos next() {
            if (this.currentPosition != null) {
                int nextX;
                int n = nextX = this.currentPosition.m_123341_() + 1 >= this.maximumOffset.m_123341_() ? this.minimumOffset.m_123341_() : this.currentPosition.m_123341_() + 1;
                int nextZ = nextX != this.minimumOffset.m_123341_() ? this.currentPosition.m_123343_() : (this.currentPosition.m_123343_() + 1 >= this.maximumOffset.m_123343_() ? this.minimumOffset.m_123343_() : this.currentPosition.m_123343_() + 1);
                int nextY = nextZ != this.minimumOffset.m_123343_() || nextX != this.minimumOffset.m_123341_() ? this.currentPosition.m_123342_() : this.currentPosition.m_123342_() + 1;
                this.currentPosition = new BlockPos(nextX, nextY, nextZ);
            } else {
                this.currentPosition = this.minimumOffset;
            }
            return this.currentPosition;
        }

        @Override
        public void remove() {
        }

        @Override
        public void resetIterator() {
            this.currentPosition = null;
        }

        @Override
        public void modifyAreaByBlockPositions(BlockPos pos1, BlockPos pos2) {
            this.setOffsets(pos1, pos2);
            this.maximumOffset = this.maximumOffset.m_7918_(1, 1, 1);
            this.resetIterator();
            this.resetCache();
        }

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.minimumOffset = new BlockPos(tag.m_128451_("xCoordmin"), tag.m_128451_("yCoordmin"), tag.m_128451_("zCoordmin"));
            this.maximumOffset = new BlockPos(tag.m_128451_("xCoordmax"), tag.m_128451_("yCoordmax"), tag.m_128451_("zCoordmax"));
        }

        @Override
        public void writeToNBT(CompoundTag tag) {
            tag.m_128405_("xCoordmin", this.minimumOffset.m_123341_());
            tag.m_128405_("yCoordmin", this.minimumOffset.m_123342_());
            tag.m_128405_("zCoordmin", this.minimumOffset.m_123343_());
            tag.m_128405_("xCoordmax", this.maximumOffset.m_123341_());
            tag.m_128405_("yCoordmax", this.maximumOffset.m_123342_());
            tag.m_128405_("zCoordmax", this.maximumOffset.m_123343_());
        }

        @Override
        public int getVolumeForOffsets(BlockPos offset1, BlockPos offset2) {
            BlockPos minPos = new BlockPos(Math.min(offset1.m_123341_(), offset2.m_123341_()), Math.min(offset1.m_123342_(), offset2.m_123342_()), Math.min(offset1.m_123343_(), offset2.m_123343_()));
            BlockPos maxPos = new BlockPos(Math.max(offset1.m_123341_(), offset2.m_123341_()), Math.max(offset1.m_123342_(), offset2.m_123342_()), Math.max(offset1.m_123343_(), offset2.m_123343_()));
            maxPos = maxPos.m_7918_(1, 1, 1);
            return (maxPos.m_123341_() - minPos.m_123341_()) * (maxPos.m_123342_() - minPos.m_123342_()) * (maxPos.m_123343_() - minPos.m_123343_());
        }

        @Override
        public boolean isWithinRange(BlockPos offset1, BlockPos offset2, int verticalLimit, int horizontalLimit) {
            BlockPos minPos = new BlockPos(Math.min(offset1.m_123341_(), offset2.m_123341_()), Math.min(offset1.m_123342_(), offset2.m_123342_()), Math.min(offset1.m_123343_(), offset2.m_123343_()));
            BlockPos maxPos = new BlockPos(Math.max(offset1.m_123341_(), offset2.m_123341_()), Math.max(offset1.m_123342_(), offset2.m_123342_()), Math.max(offset1.m_123343_(), offset2.m_123343_()));
            return minPos.m_123342_() >= -verticalLimit && maxPos.m_123342_() <= verticalLimit && minPos.m_123341_() >= -horizontalLimit && maxPos.m_123341_() <= horizontalLimit && minPos.m_123343_() >= -horizontalLimit && maxPos.m_123343_() <= horizontalLimit;
        }

        @Override
        public int getVolume() {
            return (this.maximumOffset.m_123341_() - this.minimumOffset.m_123341_()) * (this.maximumOffset.m_123342_() - this.minimumOffset.m_123342_()) * (this.maximumOffset.m_123343_() - this.minimumOffset.m_123343_());
        }

        @Override
        public boolean isWithinRange(int verticalLimit, int horizontalLimit) {
            return this.minimumOffset.m_123342_() >= -verticalLimit && this.maximumOffset.m_123342_() <= verticalLimit + 1 && this.minimumOffset.m_123341_() >= -horizontalLimit && this.maximumOffset.m_123341_() <= horizontalLimit + 1 && this.minimumOffset.m_123343_() >= -horizontalLimit && this.maximumOffset.m_123343_() <= horizontalLimit + 1;
        }

        @Override
        public boolean intersects(AreaDescriptor descriptor) {
            if (descriptor instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)descriptor;
                return this.minimumOffset.m_123341_() < rectangle.maximumOffset.m_123341_() && this.minimumOffset.m_123342_() < rectangle.maximumOffset.m_123342_() && this.minimumOffset.m_123343_() < rectangle.maximumOffset.m_123343_() && rectangle.minimumOffset.m_123341_() < this.maximumOffset.m_123341_() && rectangle.minimumOffset.m_123342_() < this.maximumOffset.m_123342_() && rectangle.minimumOffset.m_123343_() < this.maximumOffset.m_123343_();
            }
            return false;
        }

        @Override
        public AreaDescriptor offset(BlockPos offset) {
            return new Rectangle(this.minimumOffset.m_121955_((Vec3i)offset), this.maximumOffset.m_121955_((Vec3i)offset));
        }

        @Override
        public AreaDescriptor rotateDescriptor(StructurePlaceSettings settings) {
            BlockPos rotatePos1 = StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)this.minimumOffset);
            BlockPos rotatePos2 = StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)this.maximumOffset.m_7918_(-1, -1, -1));
            Rectangle rectangle = new Rectangle(this.minimumOffset, 1);
            rectangle.modifyAreaByBlockPositions(rotatePos1, rotatePos2);
            return rectangle;
        }

        public void setDoCache(boolean doCache) {
            this.cache = doCache;
        }
    }
}

