/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.registries;

import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.ItemLivingArmor;
import wayoftime.bloodmagic.common.item.ItemLivingTome;
import wayoftime.bloodmagic.common.item.ItemLivingTomeScrap;
import wayoftime.bloodmagic.common.item.soul.ItemMonsterSoul;
import wayoftime.bloodmagic.common.item.soul.ItemSoulGem;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.LivingStats;

public class BloodMagicCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"bloodmagic");
    public static final RegistryObject<CreativeModeTab> BLOODMAGIC = CREATIVE_TABS.register("bloodmagic", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.bloodmagic.creativeTab")).m_257737_(() -> ((Block)BloodMagicBlocks.BLOOD_ALTAR.get()).m_5456_().m_7968_()).m_257501_((params, output) -> {
        for (RegistryObject entry : BloodMagicItems.ITEMS.getEntries()) {
            if (!entry.getId().m_135827_().equals("bloodmagic")) continue;
            BloodMagicCreativeTabs.variantBuilder((Item)entry.get(), arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
        }
        for (RegistryObject entry : BloodMagicItems.BASICITEMS.getEntries()) {
            if (!entry.getId().m_135827_().equals("bloodmagic")) continue;
            BloodMagicCreativeTabs.variantBuilder((Item)entry.get(), arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
        }
    }).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257652_());
    public static final RegistryObject<CreativeModeTab> BLOODMAGIC_UPGRADES = CREATIVE_TABS.register("bloodmagic_upgrades", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.bloodmagic.upgradeTab")).m_257737_(() -> ((Item)BloodMagicItems.LIVING_TOME.get()).m_7968_()).m_257501_((params, output) -> LivingArmorRegistrar.UPGRADE_MAP.forEach((resourceLocation, livingUpgrade) -> {
        int exp = 0;
        ItemLivingTome item = (ItemLivingTome)BloodMagicItems.LIVING_TOME.get();
        while ((exp = livingUpgrade.getNextRequirement(exp)) != 0) {
            ItemStack tome = new ItemStack((ItemLike)item);
            item.updateLivingStats(tome, new LivingStats().setMaxPoints(livingUpgrade.getLevelCost(exp)).addExperience((ResourceLocation)resourceLocation, exp));
            output.m_246342_(tome);
        }
    })).withTabsBefore(new ResourceKey[]{BLOODMAGIC.getKey()}).m_257652_());

    public static void variantBuilder(Item item, Consumer<ItemStack> consumer) {
        if (item instanceof ItemLivingArmor) {
            ItemLivingArmor armor = (ItemLivingArmor)item;
            if (armor.m_266204_() == ArmorItem.Type.CHESTPLATE) {
                ItemStack stack = armor.m_7968_();
                armor.updateLivingStats(stack, new LivingStats());
                consumer.accept(stack);
                return;
            }
        } else {
            if (item instanceof ItemLivingTomeScrap) {
                ItemLivingTomeScrap scrap = (ItemLivingTomeScrap)item;
                ItemStack stack = scrap.m_7968_();
                scrap.setTotalUpgradePoints(stack, 256);
                consumer.accept(stack);
                return;
            }
            if (item instanceof ItemMonsterSoul) {
                ItemMonsterSoul itemMonsterSoul = (ItemMonsterSoul)item;
                ItemStack stack = itemMonsterSoul.m_7968_();
                EnumDemonWillType type = itemMonsterSoul.getType(stack);
                itemMonsterSoul.setWill(type, stack, 5.0);
                consumer.accept(stack);
                return;
            }
            if (item instanceof ItemSoulGem) {
                ItemSoulGem soulGem = (ItemSoulGem)item;
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    ItemStack stack = new ItemStack((ItemLike)soulGem);
                    soulGem.setCurrentType(type, stack);
                    soulGem.setWill(type, stack, soulGem.getMaxWill(type, stack));
                    consumer.accept(stack);
                }
                return;
            }
        }
        consumer.accept(item.m_7968_());
    }
}

