/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.command;

import com.google.common.collect.Lists;
import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.api.DietApi;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.common.util.DietValueGenerator;
import com.illusivesoulworks.diet.platform.Services;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DietCsv {
    public static void write(Player player, String modId) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Item item : Services.REGISTRY.getItems()) {
            ResourceLocation rl = Services.REGISTRY.getItemKey(item);
            if (rl == null || !modId.isEmpty() && !rl.m_135827_().equals(modId)) continue;
            DietCsv.writeStack(player, item.m_7968_(), data);
        }
        DietCsv.write(data);
    }

    public static void writeGroup(Player player, IDietGroup group) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Item tagItem : Services.REGISTRY.getTagItems(group.getTag())) {
            DietCsv.writeStack(player, tagItem.m_7968_(), data);
        }
        DietCsv.write(data);
    }

    public static void writeUncategorized(Player player) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Item item : Services.REGISTRY.getItems()) {
            ItemStack stack = item.m_7968_();
            FoodProperties food = Services.REGISTRY.getFoodProperties(stack, player);
            if (food == null || food.m_38744_() <= 0 || !DietApi.getInstance().getGroups(player, stack).isEmpty()) continue;
            data.add(new String[]{DietCsv.getName(item)});
        }
        DietCsv.write(data);
    }

    public static void writeTrails(Player player) {
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (Item item : Services.REGISTRY.getItems()) {
            List<Item> trail;
            if (DietApi.getInstance().getGroups(player, item.m_7968_()).isEmpty() || (trail = DietValueGenerator.getTrail(item)).isEmpty()) continue;
            data.add(new String[]{DietCsv.getName(item), DietCsv.getName(trail.get(0))});
            for (int i = 1; i < trail.size(); ++i) {
                data.add(new String[]{"", DietCsv.getName(trail.get(i))});
            }
        }
        DietCsv.write(data);
    }

    private static void writeStack(Player player, ItemStack stack, List<String[]> data) {
        Map<IDietGroup, Float> result = DietApi.getInstance().get(player, stack).get();
        ArrayList list = Lists.newArrayList(result.entrySet());
        if (!list.isEmpty()) {
            Map.Entry entry = (Map.Entry)list.get(0);
            data.add(new String[]{DietCsv.getName(stack.m_41720_()), ((IDietGroup)entry.getKey()).getName(), ((Float)entry.getValue()).toString()});
            for (int i = 1; i < list.size(); ++i) {
                Map.Entry entry2 = (Map.Entry)list.get(i);
                data.add(new String[]{"", ((IDietGroup)entry2.getKey()).getName(), ((Float)entry2.getValue()).toString()});
            }
        }
    }

    private static void write(List<String[]> data) {
        Path output = Paths.get(Services.PLATFORM.getGameDir() + "/logs/diet.csv", new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String[] datum : data) {
                writer.write(DietCsv.toCsv(datum));
                writer.newLine();
            }
        }
        catch (IOException e) {
            DietConstants.LOG.error("Error attempting to export diet information, aborting...");
            e.printStackTrace();
        }
    }

    private static String toCsv(String[] data) {
        return String.join((CharSequence)",", data);
    }

    private static String getName(Item item) {
        return Objects.requireNonNull(Services.REGISTRY.getItemKey(item)).toString();
    }

    public static enum ExportMode {
        ALL("all"),
        TRAILS("trails"),
        MOD_ID("mod_id"),
        GROUP("group"),
        UNCATEGORIZED("uncategorized");

        private final String id;

        private ExportMode(String idIn) {
            this.id = idIn;
        }

        public String getId() {
            return this.id;
        }
    }
}

