/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.client;

import com.illusivesoulworks.diet.client.DietClientEvents;
import com.illusivesoulworks.diet.client.screen.DynamicButton;
import com.illusivesoulworks.diet.common.integration.CuriosIntegration;
import com.illusivesoulworks.diet.common.integration.IntegrationManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="diet", value={Dist.CLIENT})
public class DietClientEventsListener {
    @SubscribeEvent
    public static void initGui(ScreenEvent.Init.Post evt) {
        DynamicButton button;
        Screen screen = evt.getScreen();
        if ((screen instanceof InventoryScreen || IntegrationManager.isCuriosLoaded() && CuriosIntegration.isCuriosScreen(screen)) && (button = DietClientEvents.getButton(screen)) != null) {
            evt.addListener((GuiEventListener)button);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            DietClientEvents.tick(Minecraft.m_91087_());
        }
    }

    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent evt) {
        Player player = evt.getEntity();
        List tooltips = evt.getToolTip();
        ItemStack stack = evt.getItemStack();
        DietClientEvents.renderItemTooltip(player, stack, tooltips);
    }

    @SubscribeEvent
    public static void renderTooltip(ScreenEvent.Render.Post evt) {
        DietClientEvents.renderEffectsTooltip(evt.getScreen(), evt.getGuiGraphics());
    }
}

