/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.vertex.format.impl;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import org.lwjgl.system.MemoryUtil;

public class CompactChunkVertex
implements ChunkVertexType {
    public static final GlVertexFormat<ChunkMeshAttribute> VERTEX_FORMAT = GlVertexFormat.builder(ChunkMeshAttribute.class, 16).addElement(ChunkMeshAttribute.VERTEX_DATA, 0, GlVertexAttributeFormat.UNSIGNED_INT, 4, false, true).build();
    public static final int STRIDE = 16;
    private static final int POSITION_MAX_VALUE = 65536;
    private static final int TEXTURE_MAX_VALUE = 65536;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_SCALE = 32.0f;

    public GlVertexFormat<ChunkMeshAttribute> getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder getEncoder() {
        return (ptr, material, vertex, sectionIndex) -> {
            MemoryUtil.memPutInt((long)(ptr + 0L), (int)(CompactChunkVertex.encodePosition(vertex.x) << 0 | CompactChunkVertex.encodePosition(vertex.y) << 16));
            MemoryUtil.memPutInt((long)(ptr + 4L), (int)(CompactChunkVertex.encodePosition(vertex.z) << 0 | CompactChunkVertex.encodeDrawParameters(material, sectionIndex) << 16));
            MemoryUtil.memPutInt((long)(ptr + 8L), (int)(CompactChunkVertex.encodeColor(vertex.color) << 0 | CompactChunkVertex.encodeLight(vertex.light) << 24));
            MemoryUtil.memPutInt((long)(ptr + 12L), (int)(CompactChunkVertex.encodeTexture(vertex.u) << 0 | CompactChunkVertex.encodeTexture(vertex.v) << 16));
            return ptr + 16L;
        };
    }

    @Override
    public String getDefine() {
        return "VERTEX_FORMAT_COMPACT";
    }

    private static int encodePosition(float value) {
        return (int)((8.0f + value) * 2048.0f);
    }

    public static float decodePosition(short value) {
        return (float)Short.toUnsignedInt(value) / 2048.0f - 8.0f;
    }

    private static int encodeDrawParameters(Material material, int sectionIndex) {
        return (sectionIndex & 0xFF) << 8 | (material.bits() & 0xFF) << 0;
    }

    private static int encodeColor(int color) {
        float brightness = ColorU8.byteToNormalizedFloat(ColorABGR.unpackAlpha(color));
        int r = ColorU8.normalizedFloatToByte(ColorU8.byteToNormalizedFloat(ColorABGR.unpackRed(color)) * brightness);
        int g = ColorU8.normalizedFloatToByte(ColorU8.byteToNormalizedFloat(ColorABGR.unpackGreen(color)) * brightness);
        int b = ColorU8.normalizedFloatToByte(ColorU8.byteToNormalizedFloat(ColorABGR.unpackBlue(color)) * brightness);
        return ColorABGR.pack(r, g, b, 0);
    }

    private static int encodeLight(int light) {
        int block = light >> 4 & 0xF;
        int sky = light >> 20 & 0xF;
        if ((light >> 0 & 0xF) > 7 && block < 15) {
            ++block;
        }
        if ((light >> 16 & 0xF) > 7 && sky < 15) {
            ++sky;
        }
        return block << 0 | sky << 4;
    }

    private static int encodeTexture(float value) {
        return (int)(Math.min(0.99999994f, value) * 65536.0f);
    }
}

