/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.songs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
import net.mehvahdjukaar.supplementaries.common.misc.songs.Song;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncSongsPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class SongsManager
extends SimpleJsonResourceReloadListener {
    private static final Map<String, Song> SONGS = new LinkedHashMap<String, Song>();
    private static final List<WeightedEntry.Wrapper<String>> SONG_WEIGHTED_LIST = new ArrayList<WeightedEntry.Wrapper<String>>();
    private static final Map<UUID, Song> CURRENTLY_PAYING = new HashMap<UUID, Song>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final SongsManager RELOAD_INSTANCE = new SongsManager();
    private static final Long2ObjectMap<IntList> RECORDING = new Long2ObjectOpenHashMap();
    private static final List<NoteBlockInstrument> WHITELIST = new ArrayList<NoteBlockInstrument>();
    private static boolean isRecording = false;

    public SongsManager() {
        super(GSON, "flute_songs");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profile) {
        SONGS.clear();
        SONG_WEIGHTED_LIST.clear();
        ArrayList temp = new ArrayList();
        jsons.forEach((key, json) -> {
            try {
                DataResult result = Song.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                Song song = (Song)result.getOrThrow(false, e -> Supplementaries.LOGGER.error("Failed to parse flute song: {}", e));
                temp.add(song);
                SongsManager.addSong(song);
            }
            catch (Exception e2) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for song " + key);
            }
        });
        if (temp.size() != 0) {
            Supplementaries.LOGGER.info("Loaded " + temp.size() + " flute songs");
        }
    }

    private static void addSong(Song song) {
        SONGS.put(song.getName(), song);
        SONG_WEIGHTED_LIST.add((WeightedEntry.Wrapper<String>)WeightedEntry.m_146290_((Object)song.getName(), (int)song.getWeight()));
    }

    public static void acceptClientSongs(List<Song> songs) {
        SONGS.clear();
        SONG_WEIGHTED_LIST.clear();
        songs.forEach(SongsManager::addSong);
    }

    public static void sendDataToClient(ServerPlayer player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncSongsPacket(SONGS.values()));
    }

    public static Song setCurrentlyPlaying(UUID id, String songKey) {
        Song song = SONGS.getOrDefault(songKey, Song.EMPTY);
        CURRENTLY_PAYING.put(id, song);
        song.validatePlayReady();
        return song;
    }

    public static void clearCurrentlyPlaying(UUID id) {
        CURRENTLY_PAYING.remove(id);
    }

    @NotNull
    private static String selectRandomSong(RandomSource random) {
        Optional song = WeightedRandom.m_216822_((RandomSource)random, SONG_WEIGHTED_LIST);
        return song.map(WeightedEntry.Wrapper::m_146310_).orElse("");
    }

    public static void playRandomSong(ItemStack stack, InstrumentItem instrument, LivingEntity entity, long timeSinceStarted) {
        Song song;
        UUID id = entity.m_20148_();
        if (!CURRENTLY_PAYING.containsKey(id)) {
            String res = null;
            if (stack.m_41788_()) {
                String name = stack.m_41786_().getString().toLowerCase(Locale.ROOT);
                for (String v : SONGS.keySet()) {
                    if (!v.equals(name)) continue;
                    res = v;
                    break;
                }
            }
            if (res == null) {
                res = SongsManager.selectRandomSong(entity.m_9236_().f_46441_);
            }
            song = SongsManager.setCurrentlyPlaying(id, res);
        } else {
            song = CURRENTLY_PAYING.get(id);
        }
        SongsManager.playSong(instrument, entity, song, timeSinceStarted);
    }

    public static boolean playSong(InstrumentItem instrumentItem, LivingEntity entity, String sandstorm, long timeSinceStarted) {
        return SongsManager.playSong(instrumentItem, entity, SONGS.getOrDefault(sandstorm, Song.EMPTY), timeSinceStarted);
    }

    public static boolean playSong(InstrumentItem instrument, LivingEntity entity, Song song, long timeSinceStarted) {
        IntList notes;
        boolean played = false;
        if (timeSinceStarted % (long)song.getTempo() == 0L && !(notes = song.getNoteToPlay(timeSinceStarted)).isEmpty() && notes.getInt(0) > 0) {
            NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntityAndSelf((Entity)entity, (Message)new ClientBoundPlaySongNotesPacket(notes, entity));
            played = true;
        }
        return played;
    }

    public static void startRecording(NoteBlockInstrument[] whitelist) {
        RECORDING.clear();
        isRecording = true;
        WHITELIST.clear();
        WHITELIST.addAll(List.of(whitelist));
    }

    public static String stopRecording(Level level, String name, int speedup) {
        isRecording = false;
        long start = Long.MAX_VALUE;
        for (Long s : RECORDING.keySet()) {
            start = Math.min(start, s);
        }
        Int2IntRBTreeMap treeMap = new Int2IntRBTreeMap();
        for (Long2ObjectMap.Entry e : RECORDING.long2ObjectEntrySet()) {
            int notes = 0;
            IntList noteList = (IntList)e.getValue();
            for (int i = 0; i < Math.min(4, noteList.size()); ++i) {
                notes = (int)((double)notes + (double)noteList.getInt(i) * Math.pow(100.0, i));
            }
            treeMap.put((int)(e.getLongKey() - start), notes);
        }
        int largestInterval = 1;
        IntArraySet intervals = new IntArraySet();
        IntArrayList arrayList = new IntArrayList();
        int lastTime = 0;
        for (Int2IntMap.Entry entry : treeMap.int2IntEntrySet()) {
            int note = entry.getIntValue();
            int key = entry.getIntKey();
            int interval = -(key - lastTime);
            lastTime = key;
            if (interval != 0) {
                intervals.add(-interval);
                if (-interval > largestInterval) {
                    largestInterval = -interval;
                }
                arrayList.add(interval);
            }
            arrayList.add(note);
        }
        int GCD = 1;
        int div = largestInterval;
        while (div > 0) {
            int d = div--;
            boolean match = intervals.intStream().allMatch(j -> j % d == 0);
            if (!match) continue;
            GCD = Math.abs(div);
            break;
        }
        IntArrayList finalNotes = new IntArrayList();
        IntListIterator d = arrayList.iterator();
        while (d.hasNext()) {
            int i = (Integer)d.next();
            if (i < 0) {
                finalNotes.add(i / GCD);
                continue;
            }
            finalNotes.add(i);
        }
        if (((String)name).isEmpty()) {
            name = "recorded-" + start;
        }
        Song song = new Song((String)name, GCD, (List<Integer>)finalNotes, "recorded in-game", 100);
        SongsManager.saveRecordedSong(song);
        SONGS.clear();
        SONGS.put((String)name, song);
        if (!level.f_46443_) {
            NetworkHandler.CHANNEL.sendToAllClientPlayers((Message)new ClientBoundSyncSongsPacket(SONGS.values()));
        }
        RECORDING.clear();
        return song.getTranslationKey();
    }

    public static void recordNote(LevelAccessor levelAccessor, BlockPos pos) {
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (isRecording) {
                BlockState state = level.m_8055_(pos);
                SongsManager.recordNote(level, (Integer)state.m_61143_((Property)NoteBlock.f_55013_) + 1, (NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_));
            }
        }
    }

    public static void recordNoteFromSound(SoundInstance sound, String name) {
        if (isRecording && name.startsWith("block.note_block")) {
            try {
                String[] parts = name.split("\\.");
                String result = parts[parts.length - 1];
                NoteBlockInstrument inst = NoteBlockInstrument.valueOf((String)result.toUpperCase(Locale.ROOT));
                float pitch = sound.m_7783_();
                int note = (int)Math.round(12.0 * (Math.log(pitch) / Math.log(2.0)) + 12.0);
                if (sound.m_8070_() == SoundSource.RECORDS) {
                    SongsManager.recordNote(Minecraft.m_91087_().m_91288_().m_9236_(), note, inst);
                }
            }
            catch (Exception ignored) {
                boolean bl = true;
            }
        }
    }

    public static void recordNote(Level level, int note, NoteBlockInstrument instrument) {
        if (WHITELIST.isEmpty() || WHITELIST.contains(instrument)) {
            IntList notes = (IntList)RECORDING.computeIfAbsent(level.m_46467_(), t -> new IntArrayList());
            notes.add(note);
        }
    }

    private static void saveRecordedSong(Song song) {
        File folder = PlatHelper.getGamePath().resolve("recorded_songs").toFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
        File exportPath = new File(folder, song.getTranslationKey() + ".json");
        try (FileWriter writer = new FileWriter(exportPath);){
            DataResult r = Song.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)song);
            r.result().ifPresent(a -> GSON.toJson((JsonElement)a.getAsJsonObject(), (Appendable)writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

