/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetBehaviorsManager;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockTarget;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.InspirationCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

class WaterCauldronInteraction
implements IFaucetBlockSource,
IFaucetBlockTarget {
    WaterCauldronInteraction() {
    }

    @Override
    public InteractionResult tryDrain(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state, FaucetBlockTile.FillAction fillAction) {
        if (state.m_60713_(Blocks.f_152476_)) {
            int waterLevel = (Integer)state.m_61143_((Property)BlockStateProperties.f_61418_);
            if (waterLevel > 0) {
                if (CompatHandler.INSPIRATIONS) {
                    return InspirationCompat.doCauldronStuff(level.m_7702_(pos), faucetTank, fillAction);
                }
                FaucetBehaviorsManager.prepareToTransferBottle(faucetTank, (SoftFluid)BuiltInSoftFluids.WATER.get());
                if (fillAction == null) {
                    return InteractionResult.SUCCESS;
                }
                if (fillAction.tryExecute()) {
                    if (waterLevel > 1) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(waterLevel - 1)), 3);
                    } else {
                        level.m_7731_(pos, Blocks.f_50256_.m_49966_(), 3);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult tryFill(Level level, SoftFluidTank faucetTank, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof AbstractCauldronBlock) {
            SoftFluid softFluid = faucetTank.getFluid();
            if (CompatHandler.INSPIRATIONS) {
                return InspirationCompat.tryAddFluid(level.m_7702_(pos), faucetTank);
            }
            if (softFluid == BuiltInSoftFluids.WATER.get()) {
                if (state.m_60713_(Blocks.f_152476_)) {
                    int levels = (Integer)state.m_61143_((Property)BlockStateProperties.f_61418_);
                    if (levels < 3) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(levels + 1)), 3);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.FAIL;
                }
                if (state.m_60713_(Blocks.f_50256_)) {
                    level.m_7731_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)BlockStateProperties.f_61418_, (Comparable)Integer.valueOf(1)), 3);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }
}

