/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TextHolder
implements IAntiqueTextProvider {
    private static final Int2ObjectArrayMap<Codec<Component[]>> CODEC_CACHE = new Int2ObjectArrayMap();
    private final int lines;
    private final int maxWidth;
    private final Component[] messages;
    private final Component[] filteredMessages;
    private final FormattedCharSequence[] renderMessages;
    private DyeColor color = DyeColor.BLACK;
    private boolean renderMessagedFiltered;
    private boolean hasGlowingText = false;
    private boolean hasAntiqueInk = false;

    private static Codec<Component[]> compCodec(int size) {
        return (Codec)CODEC_CACHE.computeIfAbsent(size, s -> ExtraCodecs.f_276686_.listOf().comapFlatMap(list -> Util.m_143795_((List)list, (int)s).map(l -> (Component[])l.toArray(Component[]::new)), components -> Arrays.stream(components).toList()));
    }

    public TextHolder(int size, int maxWidth) {
        this.lines = size;
        this.maxWidth = maxWidth;
        this.renderMessages = new FormattedCharSequence[size];
        this.messages = new Component[size];
        this.filteredMessages = new Component[size];
        Arrays.fill(this.messages, CommonComponents.f_237098_);
        Arrays.fill(this.filteredMessages, CommonComponents.f_237098_);
    }

    public int getMaxLineCharacters() {
        return (int)((float)this.getMaxLineVisualWidth() / 6.0f);
    }

    public int getMaxLineVisualWidth() {
        return this.maxWidth;
    }

    public void load(CompoundTag compound, Level level, BlockPos pos) {
        if (compound.m_128441_("TextHolder")) {
            CompoundTag com = compound.m_128469_("TextHolder");
            this.color = DyeColor.m_41057_((String)com.m_128461_("color"), (DyeColor)DyeColor.BLACK);
            this.hasGlowingText = com.m_128471_("has_glowing_text");
            this.hasAntiqueInk = com.m_128471_("has_antique_ink");
            if (this.lines != 0) {
                try {
                    Component[] v = this.decodeMessage(com.m_128423_("message"), level, pos);
                    System.arraycopy(v, 0, this.messages, 0, v.length);
                    Tag filtered = com.m_128423_("filtered_message");
                    if (filtered != null) {
                        v = this.decodeMessage(filtered, level, pos);
                        System.arraycopy(v, 0, this.filteredMessages, 0, v.length);
                    } else {
                        System.arraycopy(this.messages, 0, this.filteredMessages, 0, this.messages.length);
                    }
                    for (int j = 0; j < this.renderMessages.length; ++j) {
                        this.renderMessages[j] = null;
                    }
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.error("Failed to load textholder data for block at {}", (Object)pos);
                }
            }
        }
    }

    private Component[] decodeMessage(Tag com, Level level, BlockPos pos) {
        return (Component[])Arrays.stream((Component[])((Pair)TextHolder.compCodec(this.lines).decode((DynamicOps)NbtOps.f_128958_, (Object)com).getOrThrow(false, s -> {})).getFirst()).map(c -> {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                try {
                    return ComponentUtils.m_130731_((CommandSourceStack)SignBlockEntity.m_278808_(null, (Level)sl, (BlockPos)pos), (Component)c, null, (int)0);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
            return c;
        }).toArray(Component[]::new);
    }

    public CompoundTag save(CompoundTag compound) {
        CompoundTag com = new CompoundTag();
        com.m_128359_("color", this.color.m_41065_());
        com.m_128379_("has_glowing_text", this.hasGlowingText);
        com.m_128379_("has_antique_ink", this.hasAntiqueInk);
        if (this.lines != 0) {
            com.m_128365_("message", (Tag)TextHolder.compCodec(this.lines).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.messages).getOrThrow(false, s -> {}));
            if (this.hasFilteredMessage()) {
                com.m_128365_("filtered_message", (Tag)TextHolder.compCodec(this.lines).encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.filteredMessages).getOrThrow(false, s -> {}));
            }
        }
        compound.m_128365_("TextHolder", (Tag)com);
        return compound;
    }

    private boolean hasFilteredMessage() {
        for (int i = 0; i < this.filteredMessages.length; ++i) {
            Component component = this.filteredMessages[i];
            if (component.equals(this.messages[i])) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.lines;
    }

    public Component getMessage(int line, boolean filtered) {
        if (line >= this.lines) {
            throw new IndexOutOfBoundsException("Tried to access lie " + line + " of Text Holder of size " + this.lines);
        }
        return this.getMessages(filtered)[line];
    }

    public Component[] getMessages(boolean filtered) {
        return filtered ? this.filteredMessages : this.messages;
    }

    public void setMessage(int i, Component component) {
        this.setMessage(i, component, component);
    }

    public void setMessage(int i, Component message, Component filtered) {
        if (this.hasAntiqueInk) {
            MutableComponent t = message.m_6881_();
            message = t.m_6270_(message.m_7383_().m_131150_(ModTextures.ANTIQUABLE_FONT));
            t = filtered.m_6881_();
            filtered = t.m_6270_(filtered.m_7383_().m_131150_(ModTextures.ANTIQUABLE_FONT));
        }
        this.messages[i] = message;
        this.filteredMessages[i] = filtered;
        this.renderMessages[i] = null;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean setColor(DyeColor newColor) {
        if (newColor != this.color) {
            this.color = newColor;
            return true;
        }
        return false;
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public void setHasGlowingText(boolean glowing) {
        this.hasGlowingText = glowing;
    }

    public InteractionResult playerInteract(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        boolean success = false;
        boolean commandSuccess = this.executeClickCommandsIfPresent(player, level, pos);
        if (item == Items.f_42532_) {
            if (this.hasGlowingText || this.hasAntiqueInk) {
                level.m_5594_(null, pos, SoundEvents.f_144181_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.setAntiqueInk(false);
                this.hasGlowingText = false;
                success = true;
            }
        } else if (item == ModRegistry.ANTIQUE_INK.get()) {
            if (!this.hasAntiqueInk) {
                level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.setAntiqueInk(true);
                success = true;
            }
        } else if (item == Items.f_151056_) {
            if (!this.hasGlowingText) {
                level.m_5594_(null, pos, SoundEvents.f_144153_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.hasGlowingText = true;
                success = true;
            }
        } else {
            DyeColor dyeColor = ForgeHelper.getColor((ItemStack)stack);
            if (dyeColor != null && this.setColor(dyeColor)) {
                level.m_5594_(null, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                success = true;
            }
        }
        if (success) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, stack);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (commandSuccess) {
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean hasEditableText(boolean filtering) {
        return Arrays.stream(this.getMessages(filtering)).allMatch(component -> component.equals(CommonComponents.f_237098_) || component.m_214077_() instanceof LiteralContents);
    }

    public boolean executeClickCommandsIfPresent(Player player, Level level, BlockPos pos) {
        Component[] messages;
        boolean success = false;
        for (Component component : messages = this.getMessages(player.m_143387_())) {
            Style style = component.m_7383_();
            ClickEvent clickEvent = style.m_131182_();
            if (clickEvent == null || clickEvent.m_130622_() != ClickEvent.Action.RUN_COMMAND) continue;
            player.m_20194_().m_129892_().m_230957_(SignBlockEntity.m_278808_((Player)player, (Level)level, (BlockPos)pos), clickEvent.m_130623_());
            success = true;
        }
        return success;
    }

    @Override
    public boolean hasAntiqueInk() {
        return this.hasAntiqueInk;
    }

    @Override
    public void setAntiqueInk(boolean hasInk) {
        this.hasAntiqueInk = hasInk;
        for (int i = 0; i < this.messages.length; ++i) {
            this.setMessage(i, this.messages[i], this.filteredMessages[i]);
        }
    }

    public void clearEffects() {
        this.setColor(DyeColor.BLACK);
        this.setAntiqueInk(false);
        this.setHasGlowingText(false);
    }

    public boolean isEmpty(@Nullable Player player) {
        boolean b = player == null || player.m_143387_();
        return !Arrays.stream(this.getMessages(b)).anyMatch(component -> !component.getString().isEmpty());
    }

    public void clear() {
        Arrays.fill(this.filteredMessages, CommonComponents.f_237098_);
        Arrays.fill(this.messages, CommonComponents.f_237098_);
        this.clearEffects();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public FormattedCharSequence getRenderMessages(int line, Font font) {
        if (line >= this.lines) {
            throw new IndexOutOfBoundsException("Tried to access lie " + line + " of Text Holder of size " + this.lines);
        }
        boolean filtered = Minecraft.m_91087_().m_167974_();
        if (this.renderMessages[line] == null || this.renderMessagedFiltered != filtered) {
            List list = font.m_92923_((FormattedText)this.getMessage(line, filtered), this.getMaxLineVisualWidth());
            this.renderMessages[line] = list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        }
        return this.renderMessages[line];
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextUtil.RenderProperties computeRenderProperties(int combinedLight, Vector3f normal, BooleanSupplier shouldShowGlow) {
        return TextUtil.renderProperties((DyeColor)this.getColor(), (boolean)this.hasGlowingText(), (float)ClientConfigs.getSignColorMult(), (int)combinedLight, (Style)(this.hasAntiqueInk() ? Style.f_131099_.m_131150_(ModTextures.ANTIQUABLE_FONT) : Style.f_131099_), (Vector3f)normal, (BooleanSupplier)shouldShowGlow);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextUtil.RenderProperties getGUIRenderTextProperties() {
        return this.computeRenderProperties(0xF000F0, Direction.UP.m_253071_(), () -> true);
    }

    public void acceptClientMessages(Player player, List<FilteredText> list) {
        for (int i = 0; i < list.size(); ++i) {
            FilteredText filteredText = list.get(i);
            Style style = this.getMessage(i, player.m_143387_()).m_7383_();
            if (player.m_143387_()) {
                this.setMessage(i, (Component)Component.m_237113_((String)filteredText.m_243113_()).m_6270_(style));
                continue;
            }
            this.setMessage(i, (Component)Component.m_237113_((String)filteredText.f_215168_()).m_6270_(style), (Component)Component.m_237113_((String)filteredText.m_243113_()).m_6270_(style));
        }
    }
}

