/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.models;

import com.google.common.collect.ImmutableList;
import net.mehvahdjukaar.supplementaries.common.entities.HatStandEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class HatStandModel
extends HumanoidModel<HatStandEntity> {
    private final ModelPart basePlate;

    public HatStandModel(ModelPart modelPart) {
        super(modelPart);
        this.basePlate = modelPart.m_171324_("base_plate");
    }

    public static LayerDefinition createMesh() {
        int f = 20;
        MeshDefinition meshDefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)f);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("base_plate", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-6.0f, 3.0f, -6.0f, 12.0f, 1.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)f, (float)0.0f));
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)(3.0f + (float)f), (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public static LayerDefinition createArmorMesh() {
        MeshDefinition meshDefinition = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public void setupAnim(HatStandEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void prepareMobModel(HatStandEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.basePlate.f_104207_ = !entity.isNoBasePlate();
        float xAngle = (float)Math.PI / 180 * entity.getHeadPose().m_123156_();
        this.f_102808_.f_104204_ = (float)Math.PI / 180 * entity.getHeadPose().m_123157_();
        float zAngle = (float)Math.PI / 180 * entity.getHeadPose().m_123158_();
        this.f_102809_.m_104315_(this.f_102808_);
        this.basePlate.f_104203_ = 0.0f;
        this.basePlate.f_104204_ = (float)Math.PI / 180 * -Mth.m_14189_((float)partialTick, (float)entity.f_19859_, (float)entity.m_146908_());
        this.basePlate.f_104205_ = 0.0f;
        this.f_102808_.m_104227_(0.0f, 20.0f, 0.0f);
        this.rotateModel(this.f_102808_, 0.0f, 23.0f, 0.0f, xAngle, zAngle += entity.animation.getAngle(partialTick) * ((float)Math.PI / 180));
    }

    public void rotateModel(ModelPart model, float nrx, float nry, float nrz, float xAngle, float zAngle) {
        Vec3 oldRot = new Vec3((double)model.f_104200_, (double)model.f_104201_, (double)model.f_104202_);
        Vec3 actualRot = new Vec3((double)nrx, (double)nry, (double)nrz);
        Vec3 newRot = actualRot.m_82549_(oldRot.m_82546_(actualRot).m_82496_(-xAngle).m_82535_(-zAngle));
        model.m_104227_((float)newRot.m_7096_(), (float)newRot.m_7098_(), (float)newRot.m_7094_());
        model.f_104203_ = xAngle;
        model.f_104205_ = zAngle;
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_102808_, (Object)this.basePlate);
    }

    public ModelPart m_5585_() {
        return super.m_5585_();
    }
}

