#define LIGHT_NONE 0u
#define LIGHT_BLOCK_1 1u
#define LIGHT_BLOCK_2 2u
#define LIGHT_BLOCK_3 3u
#define LIGHT_BLOCK_4 4u
#define LIGHT_BLOCK_5 5u
#define LIGHT_BLOCK_6 6u
#define LIGHT_BLOCK_7 7u
#define LIGHT_BLOCK_8 8u
#define LIGHT_BLOCK_9 9u
#define LIGHT_BLOCK_10 10u
#define LIGHT_BLOCK_11 11u
#define LIGHT_BLOCK_12 12u
#define LIGHT_BLOCK_13 13u
#define LIGHT_BLOCK_14 14u
#define LIGHT_BLOCK_15 15u
#define LIGHT_AMETHYST_BLOCK 16u
#define LIGHT_AMETHYST_BUD_LARGE 17u
#define LIGHT_AMETHYST_BUD_MEDIUM 18u
#define LIGHT_AMETHYST_CLUSTER 19u
#define LIGHT_BEACON 20u
#define LIGHT_BLAST_FURNACE_N 21u
#define LIGHT_BLAST_FURNACE_E 22u
#define LIGHT_BLAST_FURNACE_S 23u
#define LIGHT_BLAST_FURNACE_W 24u
#define LIGHT_BREWING_STAND 25u
#define LIGHT_CANDLES_1 26u
#define LIGHT_CANDLES_2 27u
#define LIGHT_CANDLES_3 28u
#define LIGHT_CANDLES_4 29u
#define LIGHT_CANDLE_CAKE 30u
#define LIGHT_CAVEVINE_BERRIES 31u
#define LIGHT_COMPARATOR 32u
#define LIGHT_CRYING_OBSIDIAN 33u
#define LIGHT_DIAMOND_BLOCK 34u
#define LIGHT_EMERALD_BLOCK 35u
#define LIGHT_END_ROD 36u
#define LIGHT_END_STONE_LAMP 151u     // FIX INDEX
#define LIGHT_CAMPFIRE 37u
#define LIGHT_FIRE 38u
#define LIGHT_FURNACE_N 39u
#define LIGHT_FURNACE_E 40u
#define LIGHT_FURNACE_S 41u
#define LIGHT_FURNACE_W 42u
#define LIGHT_GLOWSTONE 43u
#define LIGHT_GLOW_LICHEN 44u
#define LIGHT_JACK_O_LANTERN_N 45u
#define LIGHT_JACK_O_LANTERN_E 46u
#define LIGHT_JACK_O_LANTERN_S 47u
#define LIGHT_JACK_O_LANTERN_W 48u
#define LIGHT_LANTERN 49u
#define LIGHT_LAPIS_BLOCK 50u
#define LIGHT_LIGHTING_ROD 51u
#define LIGHT_LAVA 52u
#define LIGHT_LAVA_CAULDRON 53u
#define LIGHT_MAGMA 54u
#define LIGHT_NETHER_PORTAL 55u
#define LIGHT_FROGLIGHT_OCHRE 56u
#define LIGHT_FROGLIGHT_PEARLESCENT 57u
#define LIGHT_FROGLIGHT_VERDANT 58u
#define LIGHT_RAIL_POWERED 59u
#define LIGHT_REDSTONE_BLOCK 60u
#define LIGHT_REDSTONE_LAMP 61u
#define LIGHT_REDSTONE_ORE 150u     // FIX INDEX
#define LIGHT_REDSTONE_TORCH_FLOOR 62u
#define LIGHT_REDSTONE_TORCH_WALL_N 63u
#define LIGHT_REDSTONE_TORCH_WALL_E 64u
#define LIGHT_REDSTONE_TORCH_WALL_S 65u
#define LIGHT_REDSTONE_TORCH_WALL_W 66u
#define LIGHT_REDSTONE_WIRE_1 67u
#define LIGHT_REDSTONE_WIRE_2 68u
#define LIGHT_REDSTONE_WIRE_3 69u
#define LIGHT_REDSTONE_WIRE_4 70u
#define LIGHT_REDSTONE_WIRE_5 71u
#define LIGHT_REDSTONE_WIRE_6 72u
#define LIGHT_REDSTONE_WIRE_7 73u
#define LIGHT_REDSTONE_WIRE_8 74u
#define LIGHT_REDSTONE_WIRE_9 75u
#define LIGHT_REDSTONE_WIRE_10 76u
#define LIGHT_REDSTONE_WIRE_11 77u
#define LIGHT_REDSTONE_WIRE_12 78u
#define LIGHT_REDSTONE_WIRE_13 79u
#define LIGHT_REDSTONE_WIRE_14 80u
#define LIGHT_REDSTONE_WIRE_15 81u
#define LIGHT_REPEATER 82u
#define LIGHT_RESPAWN_ANCHOR_1 83u
#define LIGHT_RESPAWN_ANCHOR_2 84u
#define LIGHT_RESPAWN_ANCHOR_3 85u
#define LIGHT_RESPAWN_ANCHOR_4 86u
#define LIGHT_SCULK_CATALYST 87u
#define LIGHT_SEA_LANTERN 88u
#define LIGHT_SEA_PICKLE_1 89u
#define LIGHT_SEA_PICKLE_2 90u
#define LIGHT_SEA_PICKLE_3 91u
#define LIGHT_SEA_PICKLE_4 92u
#define LIGHT_SHROOMLIGHT 93u
#define LIGHT_SMOKER_N 94u
#define LIGHT_SMOKER_E 95u
#define LIGHT_SMOKER_S 96u
#define LIGHT_SMOKER_W 97u
#define LIGHT_SOUL_CAMPFIRE 98u
#define LIGHT_SOUL_FIRE 99u
#define LIGHT_SOUL_LANTERN 100u
#define LIGHT_SOUL_TORCH_FLOOR 101u
#define LIGHT_SOUL_TORCH_WALL_N 102u
#define LIGHT_SOUL_TORCH_WALL_E 103u
#define LIGHT_SOUL_TORCH_WALL_S 104u
#define LIGHT_SOUL_TORCH_WALL_W 105u
#define LIGHT_TORCH_FLOOR 106u
#define LIGHT_TORCH_WALL_N 107u
#define LIGHT_TORCH_WALL_E 108u
#define LIGHT_TORCH_WALL_S 109u
#define LIGHT_TORCH_WALL_W 110u

#define LIGHT_ROSE_QUARTZ_LAMP 120u
#define LIGHT_DECO_LAMP_BLUE 121u
#define LIGHT_DECO_LAMP_GREEN 122u
#define LIGHT_DECO_LAMP_RED 123u
#define LIGHT_DECO_LAMP_YELLOW 124u

#define LIGHT_STREET_LAMP 125u
#define LIGHT_SOUL_STREET_LAMP 126u
#define LIGHT_PAPER_LAMP_BLACK 127u
#define LIGHT_PAPER_LAMP_BLUE 128u
#define LIGHT_PAPER_LAMP_BROWN 129u
#define LIGHT_PAPER_LAMP_CYAN 130u
#define LIGHT_PAPER_LAMP_GRAY 131u
#define LIGHT_PAPER_LAMP_GREEN 132u
#define LIGHT_PAPER_LAMP_LIGHT_BLUE 133u
#define LIGHT_PAPER_LAMP_LIGHT_GRAY 134u
#define LIGHT_PAPER_LAMP_LIME 135u
#define LIGHT_PAPER_LAMP_MAGENTA 136u
#define LIGHT_PAPER_LAMP_ORANGE 137u
#define LIGHT_PAPER_LAMP_PINK 138u
#define LIGHT_PAPER_LAMP_PURPLE 139u
#define LIGHT_PAPER_LAMP_RED 140u
#define LIGHT_PAPER_LAMP_WHITE 141u
#define LIGHT_PAPER_LAMP_YELLOW 142u

#define LIGHT_IGNORED 255u


uint GetSceneLightType(const in int blockId) {
    uint lightType = LIGHT_NONE;
    if (blockId < 1) return lightType;

    // 200
    switch (blockId) {
        case BLOCK_LIGHT_1:
        case BLOCK_REDSTONE_ILLUMINATOR_14:
            lightType = LIGHT_BLOCK_1;
            break;
        case BLOCK_LIGHT_2:
        case BLOCK_REDSTONE_ILLUMINATOR_13:
            lightType = LIGHT_BLOCK_2;
            break;
        case BLOCK_LIGHT_3:
        case BLOCK_REDSTONE_ILLUMINATOR_12:
            lightType = LIGHT_BLOCK_3;
            break;
        case BLOCK_LIGHT_4:
        case BLOCK_REDSTONE_ILLUMINATOR_11:
            lightType = LIGHT_BLOCK_4;
            break;
        case BLOCK_LIGHT_5:
        case BLOCK_REDSTONE_ILLUMINATOR_10:
            lightType = LIGHT_BLOCK_5;
            break;
        case BLOCK_LIGHT_6:
        case BLOCK_REDSTONE_ILLUMINATOR_9:
            lightType = LIGHT_BLOCK_6;
            break;
        case BLOCK_LIGHT_7:
        case BLOCK_REDSTONE_ILLUMINATOR_8:
            lightType = LIGHT_BLOCK_7;
            break;
        case BLOCK_LIGHT_8:
        case BLOCK_REDSTONE_ILLUMINATOR_7:
            lightType = LIGHT_BLOCK_8;
            break;
        case BLOCK_LIGHT_9:
        case BLOCK_REDSTONE_ILLUMINATOR_6:
            lightType = LIGHT_BLOCK_9;
            break;
        case BLOCK_LIGHT_10:
        case BLOCK_REDSTONE_ILLUMINATOR_5:
            lightType = LIGHT_BLOCK_10;
            break;
        case BLOCK_LIGHT_11:
        case BLOCK_REDSTONE_ILLUMINATOR_4:
            lightType = LIGHT_BLOCK_11;
            break;
        case BLOCK_LIGHT_12:
        case BLOCK_REDSTONE_ILLUMINATOR_3:
            lightType = LIGHT_BLOCK_12;
            break;
        case BLOCK_LIGHT_13:
        case BLOCK_REDSTONE_ILLUMINATOR_2:
            lightType = LIGHT_BLOCK_13;
            break;
        case BLOCK_LIGHT_14:
        case BLOCK_REDSTONE_ILLUMINATOR_1:
            lightType = LIGHT_BLOCK_14;
            break;
        case BLOCK_LIGHT_15:
        case BLOCK_REDSTONE_ILLUMINATOR_0:
            lightType = LIGHT_BLOCK_15;
            break;

        case BLOCK_AMETHYST:
            lightType = LIGHT_AMETHYST_BLOCK;
            break;
        case BLOCK_AMETHYST_BUD_LARGE:
            lightType = LIGHT_AMETHYST_BUD_LARGE;
            break;
        case BLOCK_AMETHYST_BUD_MEDIUM:
            lightType = LIGHT_AMETHYST_BUD_MEDIUM;
            break;
        case BLOCK_AMETHYST_CLUSTER:
            lightType = LIGHT_AMETHYST_CLUSTER;
            break;
        case BLOCK_BEACON:
            lightType = LIGHT_BEACON;
            break;
        case BLOCK_BLAST_FURNACE_LIT_N:
            lightType = LIGHT_BLAST_FURNACE_N;
            break;
        case BLOCK_BLAST_FURNACE_LIT_E:
            lightType = LIGHT_BLAST_FURNACE_E;
            break;
        case BLOCK_BLAST_FURNACE_LIT_S:
            lightType = LIGHT_BLAST_FURNACE_S;
            break;
        case BLOCK_BLAST_FURNACE_LIT_W:
            lightType = LIGHT_BLAST_FURNACE_W;
            break;
        case BLOCK_BREWING_STAND:
            lightType = LIGHT_BREWING_STAND;
            break;
        case BLOCK_CRYING_OBSIDIAN:
            lightType = LIGHT_CRYING_OBSIDIAN;
            break;
        case BLOCK_END_ROD:
            lightType = LIGHT_END_ROD;
            break;
        case BLOCK_CAMPFIRE_LIT:
            lightType = LIGHT_CAMPFIRE;
            break;
        case BLOCK_FIRE:
            lightType = LIGHT_FIRE;
            break;
        case BLOCK_FROGLIGHT_OCHRE:
            lightType = LIGHT_FROGLIGHT_OCHRE;
            break;
        case BLOCK_FROGLIGHT_PEARLESCENT:
            lightType = LIGHT_FROGLIGHT_PEARLESCENT;
            break;
        case BLOCK_FROGLIGHT_VERDANT:
            lightType = LIGHT_FROGLIGHT_VERDANT;
            break;
        case BLOCK_FURNACE_LIT_N:
            lightType = LIGHT_FURNACE_N;
            break;
        case BLOCK_FURNACE_LIT_E:
            lightType = LIGHT_FURNACE_E;
            break;
        case BLOCK_FURNACE_LIT_S:
            lightType = LIGHT_FURNACE_S;
            break;
        case BLOCK_FURNACE_LIT_W:
            lightType = LIGHT_FURNACE_W;
            break;
        case BLOCK_GLOWSTONE:
            lightType = LIGHT_GLOWSTONE;
            break;
        case BLOCK_GLOW_LICHEN:
            lightType = LIGHT_GLOW_LICHEN;
            break;
        case BLOCK_JACK_O_LANTERN_N:
            lightType = LIGHT_JACK_O_LANTERN_N;
            break;
        case BLOCK_JACK_O_LANTERN_E:
            lightType = LIGHT_JACK_O_LANTERN_E;
            break;
        case BLOCK_JACK_O_LANTERN_S:
            lightType = LIGHT_JACK_O_LANTERN_S;
            break;
        case BLOCK_JACK_O_LANTERN_W:
            lightType = LIGHT_JACK_O_LANTERN_W;
            break;
        case BLOCK_LANTERN_CEIL:
        case BLOCK_LANTERN_FLOOR:
            lightType = LIGHT_LANTERN;
            break;
        case BLOCK_LIGHTING_ROD_POWERED:
            lightType = LIGHT_LIGHTING_ROD;
            break;
        case BLOCK_MAGMA:
            lightType = LIGHT_MAGMA;
            break;
        case BLOCK_REDSTONE_LAMP_LIT:
            lightType = LIGHT_REDSTONE_LAMP;
            break;
        case BLOCK_REDSTONE_ORE_LIT:
            lightType = LIGHT_REDSTONE_ORE;
            break;
        case BLOCK_REDSTONE_TORCH_FLOOR_LIT:
            lightType = LIGHT_REDSTONE_TORCH_FLOOR;
            break;
        case BLOCK_REDSTONE_TORCH_WALL_N_LIT:
            lightType = LIGHT_REDSTONE_TORCH_WALL_N;
            break;
        case BLOCK_REDSTONE_TORCH_WALL_E_LIT:
            lightType = LIGHT_REDSTONE_TORCH_WALL_E;
            break;
        case BLOCK_REDSTONE_TORCH_WALL_S_LIT:
            lightType = LIGHT_REDSTONE_TORCH_WALL_S;
            break;
        case BLOCK_REDSTONE_TORCH_WALL_W_LIT:
            lightType = LIGHT_REDSTONE_TORCH_WALL_W;
            break;
        case BLOCK_RESPAWN_ANCHOR_1:
            lightType = LIGHT_RESPAWN_ANCHOR_1;
            break;
        case BLOCK_RESPAWN_ANCHOR_2:
            lightType = LIGHT_RESPAWN_ANCHOR_2;
            break;
        case BLOCK_RESPAWN_ANCHOR_3:
            lightType = LIGHT_RESPAWN_ANCHOR_3;
            break;
        case BLOCK_RESPAWN_ANCHOR_4:
            lightType = LIGHT_RESPAWN_ANCHOR_4;
            break;
        case BLOCK_SCULK_CATALYST:
            lightType = LIGHT_SCULK_CATALYST;
            break;
        case BLOCK_SEA_LANTERN:
            lightType = LIGHT_SEA_LANTERN;
            break;
        case BLOCK_SHROOMLIGHT:
            lightType = LIGHT_SHROOMLIGHT;
            break;
        case BLOCK_SMOKER_LIT_N:
            lightType = LIGHT_SMOKER_N;
            break;
        case BLOCK_SMOKER_LIT_E:
            lightType = LIGHT_SMOKER_E;
            break;
        case BLOCK_SMOKER_LIT_S:
            lightType = LIGHT_SMOKER_S;
            break;
        case BLOCK_SMOKER_LIT_W:
            lightType = LIGHT_SMOKER_W;
            break;
        case BLOCK_SOUL_CAMPFIRE_LIT:
            lightType = LIGHT_SOUL_CAMPFIRE;
            break;
        case BLOCK_SOUL_FIRE:
            lightType = LIGHT_SOUL_FIRE;
            break;
        case BLOCK_SOUL_LANTERN_CEIL:
        case BLOCK_SOUL_LANTERN_FLOOR:
            lightType = LIGHT_SOUL_LANTERN;
            break;
        case BLOCK_SOUL_TORCH_FLOOR:
            lightType = LIGHT_SOUL_TORCH_FLOOR;
            break;
        case BLOCK_SOUL_TORCH_WALL_N:
            lightType = LIGHT_SOUL_TORCH_WALL_N;
            break;
        case BLOCK_SOUL_TORCH_WALL_E:
            lightType = LIGHT_SOUL_TORCH_WALL_E;
            break;
        case BLOCK_SOUL_TORCH_WALL_S:
            lightType = LIGHT_SOUL_TORCH_WALL_S;
            break;
        case BLOCK_SOUL_TORCH_WALL_W:
            lightType = LIGHT_SOUL_TORCH_WALL_W;
            break;
        case BLOCK_TORCH_FLOOR:
            lightType = LIGHT_TORCH_FLOOR;
            break;
        case BLOCK_TORCH_WALL_N:
            lightType = LIGHT_TORCH_WALL_N;
            break;
        case BLOCK_TORCH_WALL_E:
            lightType = LIGHT_TORCH_WALL_E;
            break;
        case BLOCK_TORCH_WALL_S:
            lightType = LIGHT_TORCH_WALL_S;
            break;
        case BLOCK_TORCH_WALL_W:
            lightType = LIGHT_TORCH_WALL_W;
            break;
        case BLOCK_END_STONE_LAMP:
            lightType = LIGHT_END_STONE_LAMP;
            break;
    }

    // 400
    switch (blockId) {
        case BLOCK_CANDLE_CAKE_LIT:
            lightType = LIGHT_CANDLE_CAKE;
            break;
        case BLOCK_CANDLES_LIT_1:
        case BLOCK_CANDLE_HOLDER_LIT_1:
            lightType = LIGHT_CANDLES_1;
            break;
        case BLOCK_CANDLES_LIT_2:
        case BLOCK_CANDLE_HOLDER_LIT_2:
            lightType = LIGHT_CANDLES_2;
            break;
        case BLOCK_CANDLES_LIT_3:
        case BLOCK_CANDLE_HOLDER_LIT_3:
            lightType = LIGHT_CANDLES_3;
            break;
        case BLOCK_CANDLES_LIT_4:
        case BLOCK_CANDLE_HOLDER_LIT_4:
            lightType = LIGHT_CANDLES_4;
            break;
        case BLOCK_CAULDRON_LAVA:
            lightType = LIGHT_LAVA_CAULDRON;
            break;
    }

    switch (blockId) {
        case BLOCK_ROSE_QUARTZ_LAMP_LIT:
            lightType = LIGHT_ROSE_QUARTZ_LAMP;
            break;
        case BLOCK_DECO_LAMP_BLUE_LIT:
            lightType = LIGHT_DECO_LAMP_BLUE;
            break;
        case BLOCK_DECO_LAMP_GREEN_LIT:
            lightType = LIGHT_DECO_LAMP_GREEN;
            break;
        case BLOCK_DECO_LAMP_RED_LIT:
            lightType = LIGHT_DECO_LAMP_RED;
            break;
        case BLOCK_DECO_LAMP_YELLOW_LIT:
            lightType = LIGHT_DECO_LAMP_YELLOW;
            break;
    }

    switch (blockId) {
        case BLOCK_STREET_LAMP_LIT:
            lightType = LIGHT_STREET_LAMP;
            break;
        case BLOCK_SOUL_STREET_LAMP_LIT:
            lightType = LIGHT_SOUL_STREET_LAMP;
            break;
        case BLOCK_LAMP_LIT_BLACK:
        case BLOCK_PAPER_LAMP_LIT_BLACK:
        case BLOCK_CEILING_LIGHT_LIT_BLACK:
            lightType = LIGHT_PAPER_LAMP_BLACK;
            break;
        case BLOCK_LAMP_LIT_BLUE:
        case BLOCK_PAPER_LAMP_LIT_BLUE:
        case BLOCK_CEILING_LIGHT_LIT_BLUE:
            lightType = LIGHT_PAPER_LAMP_BLUE;
            break;
        case BLOCK_LAMP_LIT_BROWN:
        case BLOCK_PAPER_LAMP_LIT_BROWN:
        case BLOCK_CEILING_LIGHT_LIT_BROWN:
            lightType = LIGHT_PAPER_LAMP_BROWN;
            break;
        case BLOCK_LAMP_LIT_CYAN:
        case BLOCK_PAPER_LAMP_LIT_CYAN:
        case BLOCK_CEILING_LIGHT_LIT_CYAN:
            lightType = LIGHT_PAPER_LAMP_CYAN;
            break;
        case BLOCK_LAMP_LIT_GRAY:
        case BLOCK_PAPER_LAMP_LIT_GRAY:
        case BLOCK_CEILING_LIGHT_LIT_GRAY:
            lightType = LIGHT_PAPER_LAMP_GRAY;
            break;
        case BLOCK_LAMP_LIT_GREEN:
        case BLOCK_PAPER_LAMP_LIT_GREEN:
        case BLOCK_CEILING_LIGHT_LIT_GREEN:
            lightType = LIGHT_PAPER_LAMP_GREEN;
            break;
        case BLOCK_LAMP_LIT_LIGHT_BLUE:
        case BLOCK_PAPER_LAMP_LIT_LIGHT_BLUE:
        case BLOCK_CEILING_LIGHT_LIT_LIGHT_BLUE:
            lightType = LIGHT_PAPER_LAMP_LIGHT_BLUE;
            break;
        case BLOCK_LAMP_LIT_LIGHT_GRAY:
        case BLOCK_PAPER_LAMP_LIT_LIGHT_GRAY:
        case BLOCK_CEILING_LIGHT_LIT_LIGHT_GRAY:
            lightType = LIGHT_PAPER_LAMP_LIGHT_GRAY;
            break;
        case BLOCK_LAMP_LIT_LIME:
        case BLOCK_PAPER_LAMP_LIT_LIME:
        case BLOCK_CEILING_LIGHT_LIT_LIME:
            lightType = LIGHT_PAPER_LAMP_LIME;
            break;
        case BLOCK_LAMP_LIT_MAGENTA:
        case BLOCK_PAPER_LAMP_LIT_MAGENTA:
        case BLOCK_CEILING_LIGHT_LIT_MAGENTA:
            lightType = LIGHT_PAPER_LAMP_MAGENTA;
            break;
        case BLOCK_LAMP_LIT_ORANGE:
        case BLOCK_PAPER_LAMP_LIT_ORANGE:
        case BLOCK_CEILING_LIGHT_LIT_ORANGE:
            lightType = LIGHT_PAPER_LAMP_ORANGE;
            break;
        case BLOCK_LAMP_LIT_PINK:
        case BLOCK_PAPER_LAMP_LIT_PINK:
        case BLOCK_CEILING_LIGHT_LIT_PINK:
            lightType = LIGHT_PAPER_LAMP_PINK;
            break;
        case BLOCK_LAMP_LIT_PURPLE:
        case BLOCK_PAPER_LAMP_LIT_PURPLE:
        case BLOCK_CEILING_LIGHT_LIT_PURPLE:
            lightType = LIGHT_PAPER_LAMP_PURPLE;
            break;
        case BLOCK_LAMP_LIT_RED:
        case BLOCK_PAPER_LAMP_LIT_RED:
        case BLOCK_CEILING_LIGHT_LIT_RED:
            lightType = LIGHT_PAPER_LAMP_RED;
            break;
        case BLOCK_LAMP_LIT_WHITE:
        case BLOCK_PAPER_LAMP_LIT_WHITE:
        case BLOCK_CEILING_LIGHT_LIT_WHITE:
            lightType = LIGHT_PAPER_LAMP_WHITE;
            break;
        case BLOCK_LAMP_LIT_YELLOW:
        case BLOCK_PAPER_LAMP_LIT_YELLOW:
        case BLOCK_CEILING_LIGHT_LIT_YELLOW:
            lightType = LIGHT_PAPER_LAMP_YELLOW;
            break;
    }

    #if DYN_LIGHT_GLOW_BERRIES != DYN_LIGHT_BLOCK_NONE
        if (blockId == BLOCK_CAVEVINE_BERRIES) lightType = LIGHT_CAVEVINE_BERRIES;
    #endif

    #if DYN_LIGHT_LAVA != DYN_LIGHT_BLOCK_NONE
        if (blockId == BLOCK_LAVA) lightType = LIGHT_LAVA;
    #endif

    #if DYN_LIGHT_PORTAL != DYN_LIGHT_BLOCK_NONE
        if (blockId == BLOCK_NETHER_PORTAL) lightType = LIGHT_NETHER_PORTAL;
    #endif

    #if DYN_LIGHT_SEA_PICKLE != DYN_LIGHT_BLOCK_NONE
        switch (blockId) {
            case BLOCK_SEA_PICKLE_WET_1:
                lightType = LIGHT_SEA_PICKLE_1;
                break;
            case BLOCK_SEA_PICKLE_WET_2:
                lightType = LIGHT_SEA_PICKLE_2;
                break;
            case BLOCK_SEA_PICKLE_WET_3:
                lightType = LIGHT_SEA_PICKLE_3;
                break;
            case BLOCK_SEA_PICKLE_WET_4:
                lightType = LIGHT_SEA_PICKLE_4;
                break;
        }
    #endif

    #if DYN_LIGHT_REDSTONE != DYN_LIGHT_BLOCK_NONE
        switch (blockId) {
            case BLOCK_COMPARATOR_LIT:
                lightType = LIGHT_COMPARATOR;
                break;
            case BLOCK_RAIL_POWERED:
                lightType = LIGHT_RAIL_POWERED;
                break;
            case BLOCK_REDSTONE_WIRE_1:
                lightType = LIGHT_REDSTONE_WIRE_1;
                break;
            case BLOCK_REDSTONE_WIRE_2:
                lightType = LIGHT_REDSTONE_WIRE_2;
                break;
            case BLOCK_REDSTONE_WIRE_3:
                lightType = LIGHT_REDSTONE_WIRE_3;
                break;
            case BLOCK_REDSTONE_WIRE_4:
                lightType = LIGHT_REDSTONE_WIRE_4;
                break;
            case BLOCK_REDSTONE_WIRE_5:
                lightType = LIGHT_REDSTONE_WIRE_5;
                break;
            case BLOCK_REDSTONE_WIRE_6:
                lightType = LIGHT_REDSTONE_WIRE_6;
                break;
            case BLOCK_REDSTONE_WIRE_7:
                lightType = LIGHT_REDSTONE_WIRE_7;
                break;
            case BLOCK_REDSTONE_WIRE_8:
                lightType = LIGHT_REDSTONE_WIRE_8;
                break;
            case BLOCK_REDSTONE_WIRE_9:
                lightType = LIGHT_REDSTONE_WIRE_9;
                break;
            case BLOCK_REDSTONE_WIRE_10:
                lightType = LIGHT_REDSTONE_WIRE_10;
                break;
            case BLOCK_REDSTONE_WIRE_11:
                lightType = LIGHT_REDSTONE_WIRE_11;
                break;
            case BLOCK_REDSTONE_WIRE_12:
                lightType = LIGHT_REDSTONE_WIRE_12;
                break;
            case BLOCK_REDSTONE_WIRE_13:
                lightType = LIGHT_REDSTONE_WIRE_13;
                break;
            case BLOCK_REDSTONE_WIRE_14:
                lightType = LIGHT_REDSTONE_WIRE_14;
                break;
            case BLOCK_REDSTONE_WIRE_15:
                lightType = LIGHT_REDSTONE_WIRE_15;
                break;
            case BLOCK_REPEATER_LIT:
                lightType = LIGHT_REPEATER;
                break;
        }

        // if (blockId == BLOCK_GANTRY_SHAFT_POWERED)
        //     lightType = LIGHT_REDSTONE_WIRE_8;
    #endif

    #ifdef DYN_LIGHT_OREBLOCKS
        switch (blockId) {
            case BLOCK_DIAMOND:
                lightType = LIGHT_DIAMOND_BLOCK;
                break;
            case BLOCK_EMERALD:
                lightType = LIGHT_EMERALD_BLOCK;
                break;
            case BLOCK_LAPIS:
                lightType = LIGHT_LAPIS_BLOCK;
                break;
            case BLOCK_REDSTONE:
                lightType = LIGHT_REDSTONE_BLOCK;
                break;
        }
    #endif

    return lightType;
}
