/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.bettercombat.BetterCombat;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.WeaponAttributesHelper;
import net.bettercombat.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class WeaponRegistry {
    static final Logger LOGGER = LogUtils.getLogger();
    static Map<ResourceLocation, WeaponAttributes> registrations = new HashMap<ResourceLocation, WeaponAttributes>();
    static Map<ResourceLocation, AttributesContainer> containers = new HashMap<ResourceLocation, AttributesContainer>();
    private static FriendlyByteBuf encodedRegistrations = PacketByteBufs.create();

    public static void register(ResourceLocation itemId, WeaponAttributes attributes) {
        registrations.put(itemId, attributes);
    }

    static WeaponAttributes getAttributes(ResourceLocation itemId) {
        return registrations.get(itemId);
    }

    public static WeaponAttributes getAttributes(ItemStack itemStack) {
        WeaponAttributes attributes;
        if (itemStack == null) {
            return null;
        }
        if (itemStack.m_41782_() && (attributes = WeaponAttributesHelper.readFromNBT(itemStack)) != null) {
            return attributes;
        }
        Item item = itemStack.m_41720_();
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        WeaponAttributes attributes2 = WeaponRegistry.getAttributes(id);
        return attributes2;
    }

    public static void loadAttributes(ResourceManager resourceManager) {
        WeaponRegistry.loadContainers(resourceManager);
        containers.forEach((itemId, container) -> {
            if (!BuiltInRegistries.f_257033_.m_7804_(itemId)) {
                return;
            }
            WeaponRegistry.resolveAndRegisterAttributes(itemId, container);
        });
    }

    private static void loadContainers(ResourceManager resourceManager) {
        Gson gson = new Gson();
        HashMap<ResourceLocation, AttributesContainer> containers = new HashMap<ResourceLocation, AttributesContainer>();
        for (Map.Entry entry : resourceManager.m_214159_("weapon_attributes", fileName -> fileName.m_135815_().endsWith(".json")).entrySet()) {
            ResourceLocation identifier = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
                AttributesContainer container = WeaponAttributesHelper.decode(reader);
                String id = identifier.toString().replace("weapon_attributes/", "");
                id = id.substring(0, id.lastIndexOf(46));
                containers.put(new ResourceLocation(id), container);
            }
            catch (Exception e) {
                System.err.println("Failed to parse: " + identifier);
                e.printStackTrace();
            }
        }
        WeaponRegistry.containers = containers;
    }

    public static WeaponAttributes resolveAttributes(ResourceLocation itemId, AttributesContainer container) {
        try {
            ArrayList<WeaponAttributes> resolutionChain = new ArrayList<WeaponAttributes>();
            AttributesContainer current = container;
            while (current != null) {
                resolutionChain.add(0, current.attributes());
                if (current.parent() != null) {
                    current = containers.get(new ResourceLocation(current.parent()));
                    continue;
                }
                current = null;
            }
            WeaponAttributes empty = new WeaponAttributes(0.0, null, null, false, null, null);
            WeaponAttributes resolvedAttributes = resolutionChain.stream().reduce(empty, (a, b) -> {
                if (b == null) {
                    return a;
                }
                return WeaponAttributesHelper.override(a, b);
            });
            WeaponAttributesHelper.validate(resolvedAttributes);
            return resolvedAttributes;
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve weapon attributes for: " + itemId + ". Reason: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void resolveAndRegisterAttributes(ResourceLocation itemId, AttributesContainer container) {
        WeaponAttributes resolvedAttributes = WeaponRegistry.resolveAttributes(itemId, container);
        if (resolvedAttributes != null) {
            WeaponRegistry.register(itemId, resolvedAttributes);
        }
    }

    public static void encodeRegistry() {
        FriendlyByteBuf buffer = PacketByteBufs.create();
        Gson gson = new Gson();
        String json = gson.toJson(registrations);
        if (BetterCombat.config.weapon_registry_logging) {
            LOGGER.info("Weapon Attribute registry loaded: " + json);
        }
        ArrayList<String> chunks = new ArrayList<String>();
        int chunkSize = 10000;
        for (int i = 0; i < json.length(); i += chunkSize) {
            chunks.add(json.substring(i, Math.min(json.length(), i + chunkSize)));
        }
        buffer.writeInt(chunks.size());
        for (String chunk : chunks) {
            buffer.m_130070_(chunk);
        }
        LOGGER.info("Encoded Weapon Attribute registry size (with package overhead): " + buffer.readableBytes() + " bytes (in " + chunks.size() + " string chunks with the size of " + chunkSize + ")");
        encodedRegistrations = buffer;
    }

    public static void decodeRegistry(FriendlyByteBuf buffer) {
        int chunkCount = buffer.readInt();
        String json = "";
        for (int i = 0; i < chunkCount; ++i) {
            json = json.concat(buffer.m_130277_());
        }
        LOGGER.info("Decoded Weapon Attribute registry in " + chunkCount + " string chunks");
        if (BetterCombat.config.weapon_registry_logging) {
            LOGGER.info("Weapon Attribute registry received: " + json);
        }
        Gson gson = new Gson();
        Type mapType = new TypeToken<Map<String, WeaponAttributes>>(){}.getType();
        Map readRegistrations = (Map)gson.fromJson(json, mapType);
        HashMap<ResourceLocation, WeaponAttributes> newRegistrations = new HashMap<ResourceLocation, WeaponAttributes>();
        readRegistrations.forEach((key, value) -> newRegistrations.put(new ResourceLocation(key), (WeaponAttributes)value));
        registrations = newRegistrations;
    }

    public static FriendlyByteBuf getEncodedRegistry() {
        return encodedRegistrations;
    }
}

