/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.misc.Banner;
import xiroc.dungeoncrawl.util.Range;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class RandomItems {
    private static WeightedRandom<Item> STAGE_1;
    private static WeightedRandom<Item> STAGE_2;
    private static WeightedRandom<Item> STAGE_3;
    private static WeightedRandom<Item> STAGE_4;
    private static WeightedRandom<Item> STAGE_5;
    private static final Range[] UNBREAKING_LEVELS;

    public static void loadJson(ResourceManager resourceManager) {
        try {
            ResourceLocation stage1 = DungeonCrawl.locate("treasure/stage_1.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage1.toString());
            JsonArray array = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(((Resource)resourceManager.m_213713_(stage1).orElseThrow()).m_215507_()))).getAsJsonArray();
            STAGE_1 = WeightedRandom.ITEM.fromJson(array);
            ResourceLocation stage2 = DungeonCrawl.locate("treasure/stage_2.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage2.toString());
            array = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(((Resource)resourceManager.m_213713_(stage2).orElseThrow()).m_215507_()))).getAsJsonArray();
            STAGE_2 = WeightedRandom.ITEM.fromJson(array);
            ResourceLocation stage3 = DungeonCrawl.locate("treasure/stage_3.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage3.toString());
            array = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(((Resource)resourceManager.m_213713_(stage3).orElseThrow()).m_215507_()))).getAsJsonArray();
            STAGE_3 = WeightedRandom.ITEM.fromJson(array);
            ResourceLocation stage4 = DungeonCrawl.locate("treasure/stage_4.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage4.toString());
            array = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(((Resource)resourceManager.m_213713_(stage4).orElseThrow()).m_215507_()))).getAsJsonArray();
            STAGE_4 = WeightedRandom.ITEM.fromJson(array);
            ResourceLocation stage5 = DungeonCrawl.locate("treasure/stage_5.json");
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)stage5.toString());
            array = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(((Resource)resourceManager.m_213713_(stage5).orElseThrow()).m_215507_()))).getAsJsonArray();
            STAGE_5 = WeightedRandom.ITEM.fromJson(array);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static WeightedRandom<Item> itemProvider(int stage) {
        return switch (Mth.m_14045_((int)stage, (int)0, (int)4)) {
            case 0 -> STAGE_1;
            case 1 -> STAGE_2;
            case 2 -> STAGE_3;
            case 3 -> STAGE_4;
            default -> STAGE_5;
        };
    }

    public static ItemStack generate(RandomSource rand, int lootLevel) {
        ItemStack stack = new ItemStack((ItemLike)RandomItems.itemProvider(lootLevel).roll(rand));
        if (rand.m_188501_() < 0.5f + 0.1f * (float)lootLevel) {
            return EnchantmentHelper.m_220292_((RandomSource)rand, (ItemStack)stack, (int)(10 + 3 * lootLevel), (lootLevel > 2 ? 1 : 0) != 0);
        }
        return stack;
    }

    public static ItemStack createShield(RandomSource rand, int lootLevel) {
        ItemStack shield = new ItemStack((ItemLike)Items.f_42740_);
        lootLevel = Mth.m_14045_((int)lootLevel, (int)0, (int)4);
        float f = rand.m_188501_();
        if (f < 0.12f + (float)lootLevel * 0.02f) {
            shield.m_41663_(Enchantments.f_44986_, UNBREAKING_LEVELS[Mth.m_14045_((int)lootLevel, (int)0, (int)4)].nextInt(rand));
            if (f < 0.04f + (float)lootLevel * 0.01f) {
                shield.m_41663_(Enchantments.f_44962_, 1);
            }
            if (rand.m_188501_() < 0.75f) {
                shield.m_41663_(Enchantments.f_44963_, 1);
            }
        }
        shield.m_41784_().m_128365_("BlockEntityTag", (Tag)Banner.createPatterns(rand));
        return shield;
    }

    static {
        UNBREAKING_LEVELS = new Range[]{new Range(1, 1), new Range(1, 2), new Range(2, 2), new Range(2, 3), new Range(3, 3)};
    }
}

