/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.exception.DatapackLoadException;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class RandomEquipment {
    public static final int HIGHEST_STAGE = 4;
    public static final int[] ARMOR_COLORS = new int[]{11546150, 16701501, 3949738, 6192150, 16351261, 0xF9FFFE, 15961002, 0x1D1D21, 8439583, 4673362, 1481884, 8991416, 3847130};
    public static Hashtable<Integer, WeightedRandom<Item>> HELMET;
    public static Hashtable<Integer, WeightedRandom<Item>> CHESTPLATE;
    public static Hashtable<Integer, WeightedRandom<Item>> LEGGINGS;
    public static Hashtable<Integer, WeightedRandom<Item>> BOOTS;
    public static Hashtable<Integer, WeightedRandom<Item>> MELEE_WEAPON;
    public static Hashtable<Integer, WeightedRandom<Item>> RANGED_WEAPON;

    public static void loadJson(ResourceManager resourceManager) {
        HELMET = new Hashtable(5);
        CHESTPLATE = new Hashtable(5);
        LEGGINGS = new Hashtable(5);
        BOOTS = new Hashtable(5);
        MELEE_WEAPON = new Hashtable(5);
        RANGED_WEAPON = new Hashtable(5);
        try {
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_1.json"), 0);
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_2.json"), 1);
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_3.json"), 2);
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_4.json"), 3);
            RandomEquipment.loadArmorFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/armor/stage_5.json"), 4);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_1.json"), 0);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_2.json"), 1);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_3.json"), 2);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_4.json"), 3);
            RandomEquipment.loadWeaponsFromJson(resourceManager, DungeonCrawl.locate("monster/equipment/weapon/stage_5.json"), 4);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadArmorFromJson(ResourceManager resourceManager, ResourceLocation file, int stage) throws IOException {
        Resource resource = (Resource)resourceManager.m_213713_(file).orElseThrow(() -> new DatapackLoadException("Missing file: " + file));
        try {
            DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
            JsonObject object = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(resource.m_215507_()))).getAsJsonObject();
            if (object.has("helmet")) {
                HELMET.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("helmet")));
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'helmet' in {}", (Object)file.toString());
            }
            if (object.has("chestplate")) {
                CHESTPLATE.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("chestplate")));
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'chestplate' in {}", (Object)file.toString());
            }
            if (object.has("leggings")) {
                LEGGINGS.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("leggings")));
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'leggings' in {}", (Object)file.toString());
            }
            if (object.has("boots")) {
                BOOTS.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("boots")));
            } else {
                DungeonCrawl.LOGGER.warn("Missing entry 'boots' in {}", (Object)file.toString());
            }
        }
        catch (Exception e) {
            DungeonCrawl.LOGGER.error("Failed to load {}", (Object)file.toString());
            e.printStackTrace();
        }
    }

    private static void loadWeaponsFromJson(ResourceManager resourceManager, ResourceLocation file, int stage) throws IOException {
        Resource resource = (Resource)resourceManager.m_213713_(file).orElseThrow(() -> new DatapackLoadException("Missing file: " + file));
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
        JsonObject object = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(resource.m_215507_()))).getAsJsonObject();
        if (object.has("melee")) {
            MELEE_WEAPON.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("melee")));
        } else {
            DungeonCrawl.LOGGER.error("Missing entry 'melee' in {}", (Object)file.toString());
        }
        if (object.has("ranged")) {
            RANGED_WEAPON.put(stage, WeightedRandom.ITEM.fromJson(object.getAsJsonArray("ranged")));
        } else {
            DungeonCrawl.LOGGER.error("Missing entry 'ranged' in {}", (Object)file.toString());
        }
    }

    public static ItemStack[] createArmor(RandomSource rand, int stage) {
        Item item;
        if (stage > 4) {
            stage = 4;
        }
        ItemStack[] items = new ItemStack[4];
        float chance = 0.4f + 0.15f * (float)stage;
        if (HELMET.containsKey(stage)) {
            if (rand.m_188501_() < chance) {
                item = HELMET.get(stage).roll(rand);
                items[3] = RandomEquipment.createItemStack(rand, item, stage);
                if (item instanceof DyeableArmorItem) {
                    RandomEquipment.setArmorColor(items[3], RandomEquipment.getRandomColor(rand));
                }
            } else {
                items[3] = ItemStack.f_41583_;
            }
        } else {
            items[3] = ItemStack.f_41583_;
        }
        if (CHESTPLATE.containsKey(stage)) {
            if (rand.m_188501_() < chance) {
                item = CHESTPLATE.get(stage).roll(rand);
                items[2] = RandomEquipment.createItemStack(rand, item, stage);
                if (item instanceof DyeableArmorItem) {
                    RandomEquipment.setArmorColor(items[2], RandomEquipment.getRandomColor(rand));
                }
            } else {
                items[2] = ItemStack.f_41583_;
            }
        } else {
            items[2] = ItemStack.f_41583_;
        }
        if (LEGGINGS.containsKey(stage)) {
            if (rand.m_188501_() < chance) {
                item = LEGGINGS.get(stage).roll(rand);
                items[1] = RandomEquipment.createItemStack(rand, item, stage);
                if (item instanceof DyeableArmorItem) {
                    RandomEquipment.setArmorColor(items[1], RandomEquipment.getRandomColor(rand));
                }
            } else {
                items[1] = ItemStack.f_41583_;
            }
        } else {
            items[1] = ItemStack.f_41583_;
        }
        if (BOOTS.containsKey(stage)) {
            if (rand.m_188501_() < chance) {
                item = BOOTS.get(stage).roll(rand);
                items[0] = RandomEquipment.createItemStack(rand, item, stage);
                if (item instanceof DyeableArmorItem) {
                    RandomEquipment.setArmorColor(items[0], RandomEquipment.getRandomColor(rand));
                }
            } else {
                items[0] = ItemStack.f_41583_;
            }
        } else {
            items[0] = ItemStack.f_41583_;
        }
        return items;
    }

    public static ItemStack createItemStack(RandomSource rand, Item item, int stage) {
        ItemStack itemStack = EnchantmentHelper.m_220292_((RandomSource)rand, (ItemStack)new ItemStack((ItemLike)item), (int)(10 + 3 * stage), (boolean)false);
        RandomEquipment.applyDamage(itemStack, rand);
        return itemStack;
    }

    public static void applyDamage(ItemStack item, RandomSource rand) {
        if (item.m_41763_()) {
            item.m_41721_(rand.m_188503_(Math.max(1, item.m_41776_() / 2)));
        }
    }

    public static void setArmorColor(ItemStack item, int color) {
        CompoundTag tag = item.m_41784_();
        Tag displayNBT = tag.m_128423_("display");
        CompoundTag display = displayNBT == null ? new CompoundTag() : (CompoundTag)displayNBT;
        display.m_128405_("color", color);
        tag.m_128365_("display", (Tag)display);
    }

    public static ItemStack getMeleeWeapon(RandomSource rand, int stage) {
        if (stage > 4) {
            stage = 4;
        }
        if (MELEE_WEAPON.containsKey(stage)) {
            return RandomEquipment.createItemStack(rand, MELEE_WEAPON.get(stage).roll(rand), stage);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getRangedWeapon(RandomSource rand, int stage) {
        if (stage > 4) {
            stage = 4;
        }
        if (RANGED_WEAPON.containsKey(stage)) {
            return RandomEquipment.createItemStack(rand, RANGED_WEAPON.get(stage).roll(rand), stage);
        }
        return ItemStack.f_41583_;
    }

    public static int getRandomColor(RandomSource rand) {
        return ARMOR_COLORS[rand.m_188503_(ARMOR_COLORS.length)];
    }

    public static Item getItem(ResourceLocation resourceLocation) {
        if (ForgeRegistries.ITEMS.containsKey(resourceLocation)) {
            return (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        }
        DungeonCrawl.LOGGER.warn("Failed to get {} from the item registry.", (Object)resourceLocation.toString());
        return null;
    }
}

