/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import org.jetbrains.annotations.Nullable;

public class PotionNBTHelper {
    private static final MutableComponent EMPTY = Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY);

    public static void addPotionTooltip(@Nullable CompoundTag com, List<Component> tooltip, float durationFactor) {
        List list = PotionUtils.m_43566_((CompoundTag)com);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            tooltip.add((Component)EMPTY);
        } else {
            for (MobEffectInstance effectInstance : list) {
                MutableComponent translatable = Component.m_237115_((String)effectInstance.m_19576_());
                MobEffect effect = effectInstance.m_19544_();
                Map map = effect.m_19485_();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier modifier = new AttributeModifier(attributemodifier.m_22214_(), effect.m_7048_(effectInstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                        list1.add(new Pair((Object)((Attribute)entry.getKey()), (Object)modifier));
                    }
                }
                if (effectInstance.m_19564_() > 0) {
                    translatable = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{translatable, Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_()))});
                }
                if (effectInstance.m_19557_() > 20) {
                    translatable = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{translatable, MobEffectUtil.m_267641_((MobEffectInstance)effectInstance, (float)durationFactor)});
                }
                tooltip.add((Component)translatable.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!list1.isEmpty()) {
            tooltip.add(CommonComponents.f_237098_);
            tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list1) {
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double d0 = modifier.m_22218_();
                double d1 = modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? modifier.m_22218_() : modifier.m_22218_() * 100.0;
                if (d0 > 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + modifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static int getColorFromNBT(@Nullable CompoundTag com) {
        if (com != null && com.m_128425_("CustomPotionColor", 99)) {
            return com.m_128451_("CustomPotionColor");
        }
        return PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)com));
    }
}

