/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.api.Modifier;
import me.shedaniel.clothconfig2.api.ModifierKeyCode;
import me.shedaniel.clothconfig2.api.TickableWidget;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.gui.ClothRequiresRestartScreen;
import me.shedaniel.clothconfig2.gui.entries.KeyCodeEntry;
import me.shedaniel.math.Rectangle;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class AbstractConfigScreen
extends Screen
implements ConfigScreen {
    protected static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
    private final ResourceLocation backgroundLocation;
    protected boolean confirmSave;
    protected final Screen parent;
    private boolean alwaysShowTabs = false;
    private boolean transparentBackground = false;
    @Nullable
    private Component defaultFallbackCategory = null;
    public int selectedCategoryIndex = 0;
    private boolean editable = true;
    private KeyCodeEntry focusedBinding;
    private ModifierKeyCode startedKeyCode = null;
    private final List<Tooltip> tooltips = Lists.newArrayList();
    @Nullable
    private Runnable savingRunnable = null;
    @Nullable
    protected Consumer<Screen> afterInitConsumer = null;

    protected AbstractConfigScreen(Screen parent, Component title, ResourceLocation backgroundLocation) {
        super(title);
        this.parent = parent;
        this.backgroundLocation = backgroundLocation;
    }

    public List<GuiEventListener> childrenL() {
        return super.m_6702_();
    }

    @Override
    public void setSavingRunnable(@Nullable Runnable savingRunnable) {
        this.savingRunnable = savingRunnable;
    }

    @Override
    public void setAfterInitConsumer(@Nullable Consumer<Screen> afterInitConsumer) {
        this.afterInitConsumer = afterInitConsumer;
    }

    @Override
    public ResourceLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    @Override
    public boolean isRequiresRestart() {
        for (List<AbstractConfigEntry<?>> entries : this.getCategorizedEntries().values()) {
            for (AbstractConfigEntry<?> entry : entries) {
                if (!entry.getConfigError().isEmpty() || !entry.isEdited() || !entry.isRequiresRestart()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Map<Component, List<AbstractConfigEntry<?>>> getCategorizedEntries();

    @Override
    public boolean isEdited() {
        for (List<AbstractConfigEntry<?>> entries : this.getCategorizedEntries().values()) {
            for (AbstractConfigEntry<?> entry : entries) {
                if (!entry.isEdited()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isShowingTabs() {
        return this.isAlwaysShowTabs() || this.getCategorizedEntries().size() > 1;
    }

    public boolean isAlwaysShowTabs() {
        return this.alwaysShowTabs;
    }

    @ApiStatus.Internal
    public void setAlwaysShowTabs(boolean alwaysShowTabs) {
        this.alwaysShowTabs = alwaysShowTabs;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground && Minecraft.m_91087_().f_91073_ != null;
    }

    @ApiStatus.Internal
    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    public Component getFallbackCategory() {
        if (this.defaultFallbackCategory != null) {
            return this.defaultFallbackCategory;
        }
        return this.getCategorizedEntries().keySet().iterator().next();
    }

    @ApiStatus.Internal
    public void setFallbackCategory(@Nullable Component defaultFallbackCategory) {
        this.defaultFallbackCategory = defaultFallbackCategory;
        ArrayList categories = Lists.newArrayList(this.getCategorizedEntries().keySet());
        for (int i = 0; i < categories.size(); ++i) {
            Component category = (Component)categories.get(i);
            if (!category.equals(this.getFallbackCategory())) continue;
            this.selectedCategoryIndex = i;
            break;
        }
    }

    @Override
    public void saveAll(boolean openOtherScreens) {
        for (List entries : Lists.newArrayList(this.getCategorizedEntries().values())) {
            for (AbstractConfigEntry entry : entries) {
                entry.save();
            }
        }
        this.save();
        if (openOtherScreens) {
            if (this.isRequiresRestart()) {
                this.f_96541_.m_91152_((Screen)new ClothRequiresRestartScreen(this.parent));
            } else {
                this.f_96541_.m_91152_(this.parent);
            }
        }
    }

    public void save() {
        Optional.ofNullable(this.savingRunnable).ifPresent(Runnable::run);
    }

    public boolean isEditable() {
        return this.editable;
    }

    @ApiStatus.Internal
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    @ApiStatus.Internal
    public void setConfirmSave(boolean confirmSave) {
        this.confirmSave = confirmSave;
    }

    public KeyCodeEntry getFocusedBinding() {
        return this.focusedBinding;
    }

    @ApiStatus.Internal
    public void setFocusedBinding(KeyCodeEntry focusedBinding) {
        this.focusedBinding = focusedBinding;
        if (focusedBinding != null) {
            this.startedKeyCode = this.focusedBinding.getValue();
            this.startedKeyCode.setKeyCodeAndModifier(InputConstants.f_84822_, Modifier.none());
        } else {
            this.startedKeyCode = null;
        }
    }

    public boolean m_6348_(double double_1, double double_2, int int_1) {
        if (this.focusedBinding != null && this.startedKeyCode != null && !this.startedKeyCode.isUnknown() && this.focusedBinding.isAllowMouse()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.m_6348_(double_1, double_2, int_1);
    }

    public boolean m_7920_(int int_1, int int_2, int int_3) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowKey()) {
            this.focusedBinding.setValue(this.startedKeyCode);
            this.setFocusedBinding(null);
            return true;
        }
        return super.m_7920_(int_1, int_2, int_3);
    }

    public boolean m_6375_(double double_1, double double_2, int int_1) {
        if (this.focusedBinding != null && this.startedKeyCode != null && this.focusedBinding.isAllowMouse()) {
            if (this.startedKeyCode.isUnknown()) {
                this.startedKeyCode.setKeyCode(InputConstants.Type.MOUSE.m_84895_(int_1));
            } else if (this.focusedBinding.isAllowModifiers() && this.startedKeyCode.getType() == InputConstants.Type.KEYSYM) {
                int code = this.startedKeyCode.getKeyCode().m_84873_();
                if (Minecraft.f_91002_ ? code == 343 || code == 347 : code == 341 || code == 345) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(InputConstants.Type.MOUSE.m_84895_(int_1));
                    return true;
                }
                if (code == 344 || code == 340) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                    this.startedKeyCode.setKeyCode(InputConstants.Type.MOUSE.m_84895_(int_1));
                    return true;
                }
                if (code == 342 || code == 346) {
                    Modifier modifier = this.startedKeyCode.getModifier();
                    this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                    this.startedKeyCode.setKeyCode(InputConstants.Type.MOUSE.m_84895_(int_1));
                    return true;
                }
            }
            return true;
        }
        if (this.focusedBinding != null) {
            return true;
        }
        return super.m_6375_(double_1, double_2, int_1);
    }

    public boolean m_7933_(int int_1, int int_2, int int_3) {
        if (this.focusedBinding != null && (this.focusedBinding.isAllowKey() || int_1 == 256)) {
            if (int_1 != 256) {
                if (this.startedKeyCode.isUnknown()) {
                    this.startedKeyCode.setKeyCode(InputConstants.m_84827_((int)int_1, (int)int_2));
                } else if (this.focusedBinding.isAllowModifiers()) {
                    if (this.startedKeyCode.getType() == InputConstants.Type.KEYSYM) {
                        int code = this.startedKeyCode.getKeyCode().m_84873_();
                        if (Minecraft.f_91002_ ? code == 343 || code == 347 : code == 341 || code == 345) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(InputConstants.m_84827_((int)int_1, (int)int_2));
                            return true;
                        }
                        if (code == 344 || code == 340) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                            this.startedKeyCode.setKeyCode(InputConstants.m_84827_((int)int_1, (int)int_2));
                            return true;
                        }
                        if (code == 342 || code == 346) {
                            Modifier modifier = this.startedKeyCode.getModifier();
                            this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                            this.startedKeyCode.setKeyCode(InputConstants.m_84827_((int)int_1, (int)int_2));
                            return true;
                        }
                    }
                    if (Minecraft.f_91002_ ? int_1 == 343 || int_1 == 347 : int_1 == 341 || int_1 == 345) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), true, modifier.hasShift()));
                        return true;
                    }
                    if (int_1 == 344 || int_1 == 340) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(modifier.hasAlt(), modifier.hasControl(), true));
                        return true;
                    }
                    if (int_1 == 342 || int_1 == 346) {
                        Modifier modifier = this.startedKeyCode.getModifier();
                        this.startedKeyCode.setModifier(Modifier.of(true, modifier.hasControl(), modifier.hasShift()));
                        return true;
                    }
                }
            } else {
                this.focusedBinding.setValue(ModifierKeyCode.unknown());
                this.setFocusedBinding(null);
            }
            return true;
        }
        if (this.focusedBinding != null && int_1 != 256) {
            return true;
        }
        if (int_1 == 256 && this.m_6913_()) {
            return this.quit();
        }
        return super.m_7933_(int_1, int_2, int_3);
    }

    protected final boolean quit() {
        if (this.confirmSave && this.isEdited()) {
            this.f_96541_.m_91152_((Screen)new ConfirmScreen((BooleanConsumer)new QuitSaveConsumer(), (Component)Component.m_237115_((String)"text.cloth-config.quit_config"), (Component)Component.m_237115_((String)"text.cloth-config.quit_config_sure"), (Component)Component.m_237115_((String)"text.cloth-config.quit_discard"), (Component)Component.m_237115_((String)"gui.cancel")));
        } else {
            this.f_96541_.m_91152_(this.parent);
        }
        return true;
    }

    public void m_86600_() {
        super.m_86600_();
        boolean edited = this.isEdited();
        Optional.ofNullable(this.getQuitButton()).ifPresent(button -> button.m_93666_((Component)(edited ? Component.m_237115_((String)"text.cloth-config.cancel_discard") : Component.m_237115_((String)"gui.cancel"))));
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof TickableWidget)) continue;
            TickableWidget widget = (TickableWidget)child;
            widget.tick();
        }
    }

    @Nullable
    protected AbstractWidget getQuitButton() {
        return null;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        for (Tooltip tooltip : this.tooltips) {
            graphics.m_280245_(Minecraft.m_91087_().f_91062_, tooltip.getText(), tooltip.getX(), tooltip.getY());
        }
        this.tooltips.clear();
    }

    @Override
    public void addTooltip(Tooltip tooltip) {
        this.tooltips.add(tooltip);
    }

    protected void overlayBackground(GuiGraphics graphics, Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        this.overlayBackground(graphics.m_280168_(), rect, red, green, blue, startAlpha, endAlpha);
    }

    protected void overlayBackground(PoseStack matrices, Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        this.overlayBackground(matrices.m_85850_().m_252922_(), rect, red, green, blue, startAlpha, endAlpha);
    }

    protected void overlayBackground(Matrix4f matrix, Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        if (this.isTransparentBackground()) {
            return;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getBackgroundLocation());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        buffer.m_252986_(matrix, (float)rect.getMinX(), (float)rect.getMaxY(), 0.0f).m_7421_((float)rect.getMinX() / 32.0f, (float)rect.getMaxY() / 32.0f).m_6122_(red, green, blue, endAlpha).m_5752_();
        buffer.m_252986_(matrix, (float)rect.getMaxX(), (float)rect.getMaxY(), 0.0f).m_7421_((float)rect.getMaxX() / 32.0f, (float)rect.getMaxY() / 32.0f).m_6122_(red, green, blue, endAlpha).m_5752_();
        buffer.m_252986_(matrix, (float)rect.getMaxX(), (float)rect.getMinY(), 0.0f).m_7421_((float)rect.getMaxX() / 32.0f, (float)rect.getMinY() / 32.0f).m_6122_(red, green, blue, startAlpha).m_5752_();
        buffer.m_252986_(matrix, (float)rect.getMinX(), (float)rect.getMinY(), 0.0f).m_7421_((float)rect.getMinX() / 32.0f, (float)rect.getMinY() / 32.0f).m_6122_(red, green, blue, startAlpha).m_5752_();
        tesselator.m_85914_();
    }

    public boolean m_5561_(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.m_131182_();
        if (clickEvent != null && clickEvent.m_130622_() == ClickEvent.Action.OPEN_URL) {
            try {
                URI uri = new URI(clickEvent.m_130623_());
                String string = uri.getScheme();
                if (string == null) {
                    throw new URISyntaxException(clickEvent.m_130623_(), "Missing protocol");
                }
                if (!string.equalsIgnoreCase("http") && !string.equalsIgnoreCase("https")) {
                    throw new URISyntaxException(clickEvent.m_130623_(), "Unsupported protocol: " + string.toLowerCase(Locale.ROOT));
                }
                Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(openInBrowser -> {
                    if (openInBrowser) {
                        Util.m_137581_().m_137648_(uri);
                    }
                    Minecraft.m_91087_().m_91152_((Screen)this);
                }, clickEvent.m_130623_(), true));
            }
            catch (URISyntaxException e) {
                ClothConfigInitializer.LOGGER.error("Can't open url for {}", (Object)clickEvent, (Object)e);
            }
            return true;
        }
        return super.m_5561_(style);
    }

    private class QuitSaveConsumer
    implements BooleanConsumer {
        private QuitSaveConsumer() {
        }

        public void accept(boolean t) {
            if (!t) {
                AbstractConfigScreen.this.f_96541_.m_91152_((Screen)AbstractConfigScreen.this);
            } else {
                AbstractConfigScreen.this.f_96541_.m_91152_(AbstractConfigScreen.this.parent);
            }
        }
    }
}

