/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.sodium;

import com.google.common.collect.ImmutableList;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.config.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.config.QualityMode;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.SodiumOptionsGUI;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpl;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.CyclingControl;
import me.jellysquid.mods.sodium.client.gui.options.control.TickBoxControl;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.options.storage.SodiumOptionsStorage;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={SodiumOptionsGUI.class})
public abstract class SodiumSettingsMixin {
    @Shadow
    @Final
    private List<OptionPage> pages;
    private static final SodiumOptionsStorage dynamicLightsOpts = new SodiumOptionsStorage();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void DynamicLights(Screen prevScreen, CallbackInfo ci) {
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        OptionImpl qualityMode = OptionImpl.createBuilder(QualityMode.class, (OptionStorage)dynamicLightsOpts).setName(Component.m_130674_((String)"Dynamic Lights Speed")).setTooltip(Component.m_130674_((String)"Controls how often dynamic lights will update. \n\nLighting recalculation can be expensive, so slower values will give better performance.\n\nOff - Self explanatory\nSlow - Twice a second\nFast - Five times a second\nRealtime - Every tick")).setControl(option -> new CyclingControl((Option)option, QualityMode.class, new Component[]{Component.m_130674_((String)"Off"), Component.m_130674_((String)"Slow"), Component.m_130674_((String)"Fast"), Component.m_130674_((String)"Realtime")})).setBinding((options, value) -> {
            DynamicLightsConfig.Quality.set((Object)QualityMode.valueOf(value.toString()));
            LambDynLights.get().clearLightSources();
        }, options -> QualityMode.valueOf(String.valueOf(DynamicLightsConfig.Quality.get()))).setImpact(OptionImpact.MEDIUM).build();
        OptionImpl entityLighting = OptionImpl.createBuilder(Boolean.class, (OptionStorage)dynamicLightsOpts).setName(Component.m_130674_((String)"Dynamic Entity Lights")).setTooltip(Component.m_130674_((String)"Turning this on will show dynamic lighting on entities (dropped items, mobs, etc). \n\nThis can drastically increase the amount of lighting updates, even when you're not holding a torch.")).setControl(TickBoxControl::new).setBinding((options, value) -> DynamicLightsConfig.EntityLighting.set(value), options -> (Boolean)DynamicLightsConfig.EntityLighting.get()).setImpact(OptionImpact.MEDIUM).build();
        OptionImpl tileEntityLighting = OptionImpl.createBuilder(Boolean.class, (OptionStorage)dynamicLightsOpts).setName(Component.m_130674_((String)"Dynamic Block Lights")).setTooltip(Component.m_130674_((String)"Turning this on will show dynamic lighting on tile entities (furnaces, modded machines, etc). \n\nThis can drastically increase the amount of lighting updates, even when you're not holding a torch.")).setControl(TickBoxControl::new).setBinding((options, value) -> DynamicLightsConfig.TileEntityLighting.set(value), options -> (Boolean)DynamicLightsConfig.TileEntityLighting.get()).setImpact(OptionImpact.MEDIUM).build();
        groups.add(OptionGroup.createBuilder().add((Option)qualityMode).add((Option)entityLighting).add((Option)tileEntityLighting).build());
        this.pages.add(new OptionPage(Component.m_130674_((String)"Dynamic Lights"), ImmutableList.copyOf(groups)));
    }
}

