/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.starlight.mixin.common.lightengine;

import ca.spottedleaf.starlight.common.light.StarLightEngine;
import ca.spottedleaf.starlight.common.light.StarLightInterface;
import ca.spottedleaf.starlight.common.light.StarLightLightingProvider;
import ca.spottedleaf.starlight.common.util.CoordinateUtils;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ThreadedLevelLightEngine.class})
public abstract class ThreadedLevelLightEngineMixin
extends LevelLightEngine
implements StarLightLightingProvider {
    @Final
    @Shadow
    private ChunkMap f_9299_;
    @Final
    @Shadow
    private static Logger f_9296_;
    @Unique
    private final Long2IntOpenHashMap chunksBeingWorkedOn = new Long2IntOpenHashMap();

    @Shadow
    public abstract void m_9409_();

    public ThreadedLevelLightEngineMixin(LightChunkGetter chunkProvider, boolean hasBlockLight, boolean hasSkyLight) {
        super(chunkProvider, hasBlockLight, hasSkyLight);
    }

    @Unique
    private void queueTaskForSection(int chunkX, int chunkY, int chunkZ, Supplier<CompletableFuture<Void>> runnable) {
        ServerLevel world = (ServerLevel)this.getLightEngine().getWorld();
        ChunkAccess center = this.getLightEngine().getAnyChunkNow(chunkX, chunkZ);
        if (center == null || !center.m_6415_().m_62427_(ChunkStatus.f_62323_)) {
            return;
        }
        if (center.m_6415_() != ChunkStatus.f_62326_) {
            runnable.get();
            return;
        }
        if (!world.m_7726_().f_8325_.f_140135_.m_18695_()) {
            world.m_7726_().f_8325_.f_140135_.execute(() -> this.queueTaskForSection(chunkX, chunkY, chunkZ, runnable));
            return;
        }
        long key = CoordinateUtils.getChunkKey(chunkX, chunkZ);
        CompletableFuture<Void> updateFuture = runnable.get();
        if (updateFuture == null) {
            return;
        }
        int references = this.chunksBeingWorkedOn.addTo(key, 1);
        if (references == 0) {
            ChunkPos pos = new ChunkPos(chunkX, chunkZ);
            world.m_7726_().m_8387_(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, (Object)pos);
        }
        ((CompletableFuture)updateFuture.thenAcceptAsync(ignore -> {
            int newReferences = this.chunksBeingWorkedOn.get(key);
            if (newReferences == 1) {
                this.chunksBeingWorkedOn.remove(key);
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                world.m_7726_().m_8438_(StarLightInterface.CHUNK_WORK_TICKET, pos, 0, (Object)pos);
            } else {
                this.chunksBeingWorkedOn.put(key, newReferences - 1);
            }
        }, (Executor)world.m_7726_().f_8325_.f_140135_)).whenComplete((ignore, thr) -> {
            if (thr != null) {
                f_9296_.error("Failed to remove ticket level for post chunk task " + new ChunkPos(chunkX, chunkZ), thr);
            }
        });
    }

    @Overwrite
    public void m_7174_(BlockPos pos) {
        BlockPos posCopy = pos.m_7949_();
        this.queueTaskForSection(posCopy.m_123341_() >> 4, posCopy.m_123342_() >> 4, posCopy.m_123343_() >> 4, () -> this.getLightEngine().blockChange(posCopy));
    }

    @Overwrite
    public void m_9330_(ChunkPos pos) {
    }

    @Overwrite
    public void m_6191_(SectionPos pos, boolean notReady) {
        this.queueTaskForSection(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), () -> this.getLightEngine().sectionChange(pos, notReady));
    }

    @Overwrite
    public void m_142519_(ChunkPos pos) {
    }

    @Overwrite
    public void m_9335_(ChunkPos pos, boolean lightEnabled) {
    }

    @Overwrite
    public void m_284126_(LightLayer lightType, SectionPos pos, @Nullable DataLayer nibbles) {
    }

    @Overwrite
    public void m_6462_(ChunkPos pos, boolean retainData) {
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> m_284138_(ChunkAccess chunk, boolean lit) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Overwrite
    public CompletableFuture<ChunkAccess> m_9353_(ChunkAccess chunk, boolean lit) {
        ChunkPos chunkPos = chunk.m_7697_();
        return CompletableFuture.supplyAsync(() -> {
            Boolean[] emptySections = StarLightEngine.getEmptySectionsForChunk(chunk);
            if (!lit) {
                chunk.m_8094_(false);
                this.getLightEngine().lightChunk(chunk, emptySections);
                chunk.m_8094_(true);
            } else {
                this.getLightEngine().forceLoadInChunk(chunk, emptySections);
                this.getLightEngine().checkChunkEdges(chunkPos.f_45578_, chunkPos.f_45579_);
            }
            this.f_9299_.m_140375_(chunkPos);
            return chunk;
        }, runnable -> {
            this.getLightEngine().scheduleChunkLight(chunkPos, runnable);
            this.m_9409_();
        }).whenComplete((c, throwable) -> {
            if (throwable != null) {
                f_9296_.error("Failed to light chunk " + chunkPos, throwable);
            }
        });
    }
}

