/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.IMapDisplay;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.NoticeBoardBlock;
import net.mehvahdjukaar.supplementaries.common.inventories.NoticeBoardContainerMenu;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CCCompat;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BannerPatternItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class NoticeBoardBlockTile
extends ItemDisplayTile
implements Nameable,
IMapDisplay,
ITextHolderProvider {
    private final TextHolder textHolder;
    private boolean isWaxed = false;
    private int pageNumber = 0;
    @Nullable
    private UUID playerWhoMayEdit;
    private String text = null;
    private float fontScale = 1.0f;
    private List<FormattedCharSequence> cachedPageLines = Collections.emptyList();
    private boolean needsVisualRefresh = true;
    private Material cachedPattern = null;
    private boolean isNormalItem = false;

    public NoticeBoardBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.NOTICE_BOARD_TILE.get(), pos, state);
        this.textHolder = new TextHolder(1, 90);
    }

    public Component m_6820_() {
        return Component.m_237115_((String)"block.supplementaries.notice_board");
    }

    public void updateTileOnInventoryChanged() {
        boolean shouldHaveBook = !this.getDisplayedItem().m_41619_();
        BlockState state = this.m_58900_();
        if ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61440_) != shouldHaveBook) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61440_, (Comparable)Boolean.valueOf(shouldHaveBook)), 2);
            if (shouldHaveBook) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.85f);
            } else {
                this.pageNumber = 0;
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.5f);
            }
        }
    }

    @Override
    public ItemStack getMapStack() {
        return this.getDisplayedItem();
    }

    public void updateClientVisualsOnLoad() {
        ItemStack itemstack = this.getDisplayedItem();
        Item item = itemstack.m_41720_();
        this.cachedPattern = null;
        if (item instanceof BannerPatternItem) {
            BannerPatternItem bannerPatternItem = (BannerPatternItem)item;
            this.cachedPattern = ModMaterials.getFlagMaterialForPatternItem(bannerPatternItem);
        }
        this.needsVisualRefresh = true;
        this.cachedPageLines = Collections.emptyList();
        this.text = null;
        this.updateText();
        this.isNormalItem = !NoticeBoardBlockTile.isPageItem(itemstack.m_41720_());
    }

    public boolean isNormalItem() {
        return this.isNormalItem;
    }

    public void updateText() {
        ItemStack itemstack = this.getDisplayedItem();
        Item item = itemstack.m_41720_();
        CompoundTag com = itemstack.m_41783_();
        if (item instanceof WrittenBookItem && WrittenBookItem.m_43471_((CompoundTag)com) || item instanceof WritableBookItem && WritableBookItem.m_43452_((CompoundTag)com)) {
            ListTag pages = com.m_128437_("pages", 8).m_6426_();
            if (!pages.isEmpty()) {
                if (this.pageNumber >= pages.size()) {
                    this.pageNumber %= pages.size();
                }
                this.text = pages.m_128778_(this.pageNumber);
            }
        } else if (CompatHandler.COMPUTERCRAFT && CCCompat.isPrintedBook(item) && com != null) {
            int pages = CCCompat.getPages(itemstack);
            if (this.pageNumber >= pages) {
                this.pageNumber %= pages;
            }
            String[] text = CCCompat.getText(itemstack);
            StringBuilder combined = new StringBuilder();
            for (int i = 0; i < 21; ++i) {
                int ind = this.pageNumber * 21 + i;
                if (ind >= text.length) continue;
                combined.append(text[ind]);
                combined.append(" ");
            }
            this.text = combined.toString();
        }
    }

    public void m_142466_(CompoundTag compound) {
        this.pageNumber = compound.m_128451_("PageNumber");
        this.textHolder.load(compound, this.f_58857_, this.f_58858_);
        super.m_142466_(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("PageNumber", this.pageNumber);
        this.textHolder.save(tag);
    }

    public AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new NoticeBoardContainerMenu(id, player, this);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return this.m_7983_() && (CommonConfigs.Building.NOTICE_BOARDS_UNRESTRICTED.get() != false || NoticeBoardBlockTile.isPageItem(stack.m_41720_()));
    }

    public static boolean isPageItem(Item item) {
        return item.m_204114_().m_203656_(ItemTags.f_13162_) || item instanceof MapItem || item instanceof BannerPatternItem || CompatHandler.COMPUTERCRAFT && CCCompat.isPrintedBook(item);
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean shouldSkipTileRenderer() {
        return (Boolean)this.m_58900_().m_61143_((Property)NoticeBoardBlock.CULLED) != false || (Boolean)this.m_58900_().m_61143_((Property)NoticeBoardBlock.HAS_BOOK) == false;
    }

    public Material getCachedPattern() {
        return this.cachedPattern;
    }

    public String getText() {
        return this.text;
    }

    public DyeColor getDyeColor() {
        return this.textHolder.getColor();
    }

    public boolean isGlowing() {
        return this.textHolder.hasGlowingText();
    }

    public boolean hasAntiqueInk() {
        return this.textHolder.hasAntiqueInk();
    }

    public TextUtil.RenderProperties computeRenderProperties(int frontLight, Vector3f normal, BooleanSupplier isNear) {
        return this.textHolder.computeRenderProperties(frontLight, normal, isNear);
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float s) {
        this.fontScale = s;
    }

    public void setCachedPageLines(List<FormattedCharSequence> l) {
        this.cachedPageLines = l;
    }

    public List<FormattedCharSequence> getRendererLines() {
        return this.cachedPageLines;
    }

    public boolean needsVisualUpdate() {
        if (this.needsVisualRefresh) {
            this.needsVisualRefresh = false;
            return true;
        }
        return false;
    }

    public Direction getDirection() {
        return (Direction)this.m_58900_().m_61143_((Property)NoticeBoardBlock.FACING);
    }

    public void turnPage() {
        ++this.pageNumber;
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 1.45f);
        this.m_6596_();
    }

    public InteractionResult interact(Player player, InteractionHand handIn, BlockPos pos, BlockState state, BlockHitResult hit) {
        InteractionResult res;
        Level level = player.m_9236_();
        if (player.m_6144_() && !this.m_7983_() && player.m_21120_(handIn).m_41619_()) {
            ItemStack it = this.m_8016_(0);
            BlockPos newPos = pos.m_121955_(((Direction)state.m_61143_((Property)NoticeBoardBlock.FACING)).m_122436_());
            ItemEntity drop = new ItemEntity(level, (double)newPos.m_123341_() + 0.5, (double)newPos.m_123342_() + 0.5, (double)newPos.m_123343_() + 0.5, it);
            drop.m_32060_();
            level.m_7967_((Entity)drop);
            this.m_6596_();
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (hit.m_82434_() == state.m_61143_((Property)NoticeBoardBlock.FACING) && (res = super.interact(player, handIn)).m_19077_()) {
            return res;
        }
        InteractionResult r = this.interactWithTextHolder(0, level, pos, state, player, handIn);
        if (r != InteractionResult.PASS) {
            return r;
        }
        if (!CommonConfigs.Building.NOTICE_BOARD_GUI.get().booleanValue()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            this.tryOpeningEditGui((ServerPlayer)player, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @Override
    public void setPlayerWhoMayEdit(@Nullable UUID uuid) {
        this.playerWhoMayEdit = uuid;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    @Override
    public TextHolder getTextHolder(int ind) {
        return this.textHolder;
    }

    public void openScreen(Level level, BlockPos pos, Player player) {
    }

    @Override
    public boolean shouldUseContainerMenu() {
        return true;
    }

    @Override
    public boolean isWaxed() {
        return this.isWaxed;
    }

    @Override
    public void setWaxed(boolean b) {
        this.isWaxed = b;
    }
}

