/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.MathUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class CookingPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<CookingPotSupport> SUPPORT = EnumProperty.m_61587_((String)"support", CookingPotSupport.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public CookingPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SUPPORT, (Comparable)((Object)CookingPotSupport.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41619_() && player.m_6144_()) {
            level.m_46597_(pos, (BlockState)state.m_61124_(SUPPORT, (Comparable)((Object)(((CookingPotSupport)((Object)state.m_61143_(SUPPORT))).equals((Object)CookingPotSupport.HANDLE) ? this.getTrayState((LevelAccessor)level, pos) : CookingPotSupport.HANDLE))));
            level.m_5594_(null, pos, SoundEvents.f_12028_, SoundSource.BLOCKS, 0.7f, 1.0f);
        } else if (!level.f_46443_) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof CookingPotBlockEntity) {
                CookingPotBlockEntity cookingPotEntity = (CookingPotBlockEntity)tileEntity;
                ItemStack servingStack = cookingPotEntity.useHeldItemOnMeal(heldStack);
                if (servingStack != ItemStack.f_41583_) {
                    if (!player.m_150109_().m_36054_(servingStack)) {
                        player.m_36176_(servingStack, false);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)cookingPotEntity, (BlockPos)pos);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((CookingPotSupport)((Object)state.m_61143_(SUPPORT))).equals((Object)CookingPotSupport.TRAY) ? SHAPE_WITH_TRAY : SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        FluidState fluid = level.m_6425_(context.m_8083_());
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        if (context.m_43719_().equals((Object)Direction.DOWN)) {
            return (BlockState)state.m_61124_(SUPPORT, (Comparable)((Object)CookingPotSupport.HANDLE));
        }
        return (BlockState)state.m_61124_(SUPPORT, (Comparable)((Object)this.getTrayState((LevelAccessor)level, pos)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (facing.m_122434_().equals((Object)Direction.Axis.Y) && !((CookingPotSupport)((Object)state.m_61143_(SUPPORT))).equals((Object)CookingPotSupport.HANDLE)) {
            return (BlockState)state.m_61124_(SUPPORT, (Comparable)((Object)this.getTrayState(level, currentPos)));
        }
        return state;
    }

    private CookingPotSupport getTrayState(LevelAccessor level, BlockPos pos) {
        if (level.m_8055_(pos.m_7495_()).m_204336_(ModTags.TRAY_HEAT_SOURCES)) {
            return CookingPotSupport.TRAY;
        }
        return CookingPotSupport.NONE;
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(level, pos, state);
        CookingPotBlockEntity cookingPotEntity = (CookingPotBlockEntity)level.m_7702_(pos);
        if (cookingPotEntity != null) {
            CompoundTag nbt = cookingPotEntity.writeMeal(new CompoundTag());
            if (!nbt.m_128456_()) {
                stack.m_41700_("BlockEntityTag", (Tag)nbt);
            }
            if (cookingPotEntity.m_8077_()) {
                stack.m_41714_(cookingPotEntity.m_7770_());
            }
        }
        return stack;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof CookingPotBlockEntity) {
                CookingPotBlockEntity cookingPotEntity = (CookingPotBlockEntity)tileEntity;
                Containers.m_19010_((Level)level, (BlockPos)pos, cookingPotEntity.getDroppableInventory());
                cookingPotEntity.getUsedRecipesAndPopExperience(level, Vec3.m_82512_((Vec3i)pos));
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, level, tooltip, flagIn);
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        ItemStack mealStack = CookingPotBlockEntity.getMealFromItem(stack);
        if (!mealStack.m_41619_()) {
            MutableComponent textServingsOf = mealStack.m_41613_() == 1 ? TextUtils.getTranslation("tooltip.cooking_pot.single_serving", new Object[0]) : TextUtils.getTranslation("tooltip.cooking_pot.many_servings", mealStack.m_41613_());
            tooltip.add((Component)textServingsOf.m_130940_(ChatFormatting.GRAY));
            MutableComponent textMealName = mealStack.m_41786_().m_6881_();
            tooltip.add((Component)textMealName.m_130940_(mealStack.m_41791_().f_43022_));
        } else {
            MutableComponent textEmpty = TextUtils.getTranslation("tooltip.cooking_pot.empty", new Object[0]);
            tooltip.add((Component)textEmpty.m_130940_(ChatFormatting.GRAY));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, SUPPORT, WATERLOGGED});
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tileEntity;
        if (stack.m_41788_() && (tileEntity = level.m_7702_(pos)) instanceof CookingPotBlockEntity) {
            ((CookingPotBlockEntity)tileEntity).setCustomName(stack.m_41786_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        CookingPotBlockEntity cookingPotEntity;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CookingPotBlockEntity && (cookingPotEntity = (CookingPotBlockEntity)tileEntity).isHeated()) {
            SoundEvent boilSound = !cookingPotEntity.getMeal().m_41619_() ? (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL_SOUP.get() : (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL.get();
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (random.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, boilSound, SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CookingPotBlockEntity) {
            ItemStackHandler inventory = ((CookingPotBlockEntity)tileEntity).getInventory();
            return MathUtils.calcRedstoneFromItemHandler((IItemHandlerModifiable)inventory);
        }
        return 0;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntityTypes.COOKING_POT.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.f_46443_) {
            return CookingPotBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.COOKING_POT.get()), CookingPotBlockEntity::animationTick);
        }
        return CookingPotBlock.m_152132_(blockEntity, (BlockEntityType)((BlockEntityType)ModBlockEntityTypes.COOKING_POT.get()), CookingPotBlockEntity::cookingTick);
    }
}

