/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item.crafting;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RecipeFillPalette
extends CustomRecipe {
    public RecipeFillPalette(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    private boolean isPalette(ItemStack stack) {
        return stack.m_41720_() instanceof ItemPalette;
    }

    private boolean isDye(ItemStack stack) {
        return stack.m_41720_() instanceof DyeItem;
    }

    private int findPalette(CraftingContainer inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!this.isPalette(stack)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private ArrayList<ItemStack> findDyes(CraftingContainer inv, int paletteId) {
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            if (i == paletteId) continue;
            ItemStack stack = inv.m_8020_(i);
            if (this.isDye(stack)) {
                dyes.add(stack);
                continue;
            }
            if (stack.m_41619_()) continue;
            return null;
        }
        return dyes;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        int paletteId = this.findPalette(inv);
        if (paletteId < 0) {
            return false;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, paletteId);
        return dyes != null && !dyes.isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv, @NotNull RegistryAccess access) {
        int paletteId = this.findPalette(inv);
        if (paletteId < 0) {
            return ItemStack.f_41583_;
        }
        ArrayList<ItemStack> dyes = this.findDyes(inv, paletteId);
        if (dyes == null || dyes.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack inputPalette = inv.m_8020_(paletteId);
        CompoundTag orgTag = inputPalette.m_41784_().m_6426_();
        byte[] basicColors = orgTag.m_128441_("basic") ? orgTag.m_128463_("basic") : new byte[16];
        for (ItemStack dye : dyes) {
            DyeColor color = ((DyeItem)dye.m_41720_()).m_41089_();
            int realColorId = 15 - color.m_41060_();
            if (basicColors[realColorId] > 0) {
                return ItemStack.f_41583_;
            }
            basicColors[realColorId] = 1;
        }
        orgTag.m_128382_("basic", basicColors);
        ItemStack result = new ItemStack((ItemLike)Items.ITEM_PALETTE.get());
        result.m_41751_(orgTag);
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Items.CRAFTING_SPECIAL_PALETTE_FILLING.get();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }
}

