/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.test;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.Random;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRuleTypeRegistry;
import me.shedaniel.rei.api.client.entry.filtering.base.BasicFilteringRule;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.TestOnly;

@OnlyIn(value=Dist.CLIENT)
@TestOnly
public class REITestPlugin
implements REIClientPlugin {
    private final Random random = new Random();
    private BasicFilteringRule.MarkDirty markDirty;

    public REITestPlugin() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rei_test_reload_filtering").then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)registry)).executes(context -> {
            BasicFilteringRule<?> basic = FilteringRuleTypeRegistry.getInstance().basic();
            basic.hide(EntryStacks.of(((ItemInput)context.getArgument("item", ItemInput.class)).m_120980_(1, false)));
            return 0;
        }))).executes(context -> {
            if (this.markDirty != null) {
                this.markDirty.markDirty();
            }
            return 0;
        })));
    }

    @Override
    public void preStage(PluginManager<REIClientPlugin> manager, ReloadStage stage) {
        InternalLogger.getInstance().error("REI Test Plugin is enabled! If you see this unintentionally, please report this!");
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
    }

    @Override
    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        int i = 0;
        for (Item item : BuiltInRegistries.f_257033_) {
            if (i++ % 10 != 0) continue;
            registry.group(BuiltInRegistries.f_257033_.m_7981_((Object)item), (Component)Component.m_237113_((String)BuiltInRegistries.f_257033_.m_7981_((Object)item).toString()), stack -> stack.getType() == VanillaEntryTypes.ITEM && ((ItemStack)stack.castValue()).m_150930_(item));
        }
    }

    @Override
    public void registerBasicEntryFiltering(BasicFilteringRule<?> rule) {
        this.markDirty = rule.hide(() -> {
            EntryIngredient.Builder builder = EntryIngredient.builder();
            for (Item item : BuiltInRegistries.f_257033_) {
                if (this.random.nextInt() % 10 != 0) continue;
                builder.add((EntryStack<?>)EntryStacks.of((ItemLike)item));
            }
            return builder.build();
        });
    }

    @Override
    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerNbt((Item[])BuiltInRegistries.f_257033_.m_123024_().toArray(Item[]::new));
    }

    public EntryStack<ItemStack> transformStack(EntryStack<ItemStack> stack) {
        CompoundTag tag = stack.getValue().m_41784_();
        tag.m_128405_("Whatever", this.random.nextInt(Integer.MAX_VALUE));
        return stack;
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.registerSystemFavorites(() -> {
            GameType mode = Minecraft.m_91087_().f_91072_.m_105295_();
            switch (mode) {
                case SURVIVAL: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((ItemLike)Items.f_41905_)));
                }
                case CREATIVE: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((ItemLike)Items.f_42201_)));
                }
                case ADVENTURE: {
                    return ImmutableList.of((Object)FavoriteEntry.fromEntryStack(EntryStacks.of((ItemLike)Items.f_42146_)));
                }
            }
            return ImmutableList.of();
        });
    }

    private /* synthetic */ EntryStack lambda$registerEntries$4(ItemStack stack, int value) {
        return this.transformStack(EntryStacks.of(stack));
    }

    private /* synthetic */ EntryStack lambda$registerEntries$3(Item item, int value) {
        return this.transformStack(EntryStacks.of((ItemLike)item));
    }
}

