/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.runtime;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import dev.architectury.platform.Platform;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.search.method.InputMethodRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.search.method.DefaultInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.BomopofoInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.DoublePinyinInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.JyutpingInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.PinyinInputMethod;
import me.shedaniel.rei.impl.client.search.method.unihan.UniHanManager;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryListener;
import me.shedaniel.rei.impl.common.util.HNEntryStackWrapper;
import me.shedaniel.rei.plugin.autocrafting.DefaultCategoryHandler;
import me.shedaniel.rei.plugin.client.runtime.FilteredStacksVisibilityHandler;
import me.shedaniel.rei.plugin.client.runtime.InputMethodWatcher;
import me.shedaniel.rei.plugin.client.runtime.PluginStageExecutionWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchBarHighlightWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchFilterPrepareWatcher;
import me.shedaniel.rei.plugin.client.runtime.SearchFilterWatcher;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class DefaultClientRuntimePlugin
implements REIClientPlugin {
    private final FilteredStacksVisibilityHandler filteredStacksVisibilityHandler = new FilteredStacksVisibilityHandler();

    public DefaultClientRuntimePlugin() {
        PluginStageExecutionWatcher watcher = new PluginStageExecutionWatcher();
        for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
            instance.registerReloadable(watcher.reloadable(instance));
        }
        REIRuntimeImpl.getInstance().addHintProvider(watcher);
        REIRuntimeImpl.getInstance().addHintProvider(new SearchBarHighlightWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new SearchFilterPrepareWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new SearchFilterWatcher());
        REIRuntimeImpl.getInstance().addHintProvider(new InputMethodWatcher());
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        if (((Boolean)ClientHelperImpl.getInstance().isAprilFools.m_13971_()).booleanValue()) {
            registry.addEntry(ClientEntryStacks.of(new Renderer(){
                private ResourceLocation id = new ResourceLocation("roughlyenoughitems", "textures/gui/kirb.png");

                @Override
                public void render(GuiGraphics graphics, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    graphics.m_280444_(this.id, bounds.x, bounds.getMaxX(), bounds.y, bounds.getMaxY(), 0, 0.0f, 1.0f, 0.0f, 1.0f);
                }

                @Override
                @Nullable
                public Tooltip getTooltip(TooltipContext context) {
                    return Tooltip.create(context.getPoint(), new Component[]{Component.m_237113_((String)"Kirby"), ClientHelper.getInstance().getFormattedModFromModId("Dream Land")});
                }
            }));
        }
        ((EntryRegistryImpl)registry).listeners.add(new EntryRegistryListener(){

            @Override
            public void onReFilter(List<HNEntryStackWrapper> stacks) {
                DefaultClientRuntimePlugin.this.filteredStacksVisibilityHandler.reset();
            }
        });
    }

    @Override
    public void registerDisplays(DisplayRegistry registry) {
        this.filteredStacksVisibilityHandler.reset();
        registry.registerVisibilityPredicate(this.filteredStacksVisibilityHandler);
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        ExclusionZones zones = registry.exclusionZones();
        zones.register(DefaultDisplayViewingScreen.class, screen -> {
            Panel widget = screen.getWorkingStationsBaseWidget();
            if (widget == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(widget.getBounds().clone());
        });
        zones.register(Screen.class, screen -> {
            FavoritesListWidget widget = ScreenOverlayImpl.getFavoritesListWidget();
            if (widget != null && widget.togglePanelButton.isVisible()) {
                return Collections.singletonList(widget.togglePanelButton.bounds);
            }
            return Collections.emptyList();
        });
        registry.registerDraggableComponentProvider(DraggableComponentProviderWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().m_6702_(), DraggableComponentProviderWidget.class::isInstance);
        }));
        registry.registerDraggableComponentVisitor(DraggableComponentVisitorWidget.from(context -> {
            if (RoughlyEnoughItemsCoreClient.shouldReturn(context.getScreen()) || !REIRuntime.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIRuntime.getInstance().getOverlay().get().m_6702_(), DraggableComponentVisitorWidget.class::isInstance);
        }));
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(EntryStackFavoriteType.INSTANCE.id, EntryStackFavoriteType.INSTANCE);
    }

    @Override
    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(new DefaultCategoryHandler());
    }

    @Override
    public void registerInputMethods(InputMethodRegistry registry) {
        registry.add(DefaultInputMethod.ID, DefaultInputMethod.INSTANCE);
        UniHanManager manager = new UniHanManager(Platform.getConfigFolder().resolve("roughlyenoughitems/unihan.zip"));
        registry.add(new ResourceLocation("rei:pinyin"), new PinyinInputMethod(manager));
        registry.add(new ResourceLocation("rei:jyutping"), new JyutpingInputMethod(manager));
        registry.add(new ResourceLocation("rei:bomopofo"), new BomopofoInputMethod(manager));
        registry.add(new ResourceLocation("rei:double_pinyin"), new DoublePinyinInputMethod(manager));
    }

    private static enum EntryStackFavoriteType implements FavoriteEntryType<EntryStackFavoriteEntry>
    {
        INSTANCE(FavoriteEntryType.ENTRY_STACK);

        private final String key = "data";
        private ResourceLocation id;

        private EntryStackFavoriteType(ResourceLocation id) {
            this.id = id;
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> read(CompoundTag object) {
            EntryStack<?> stack;
            try {
                stack = EntryStack.read(object.m_128469_("data"));
            }
            catch (Throwable throwable) {
                return DataResult.error(throwable::getMessage);
            }
            return DataResult.success((Object)new EntryStackFavoriteEntry(stack), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public DataResult<EntryStackFavoriteEntry> fromArgs(Object ... args) {
            if (args.length == 0) {
                return DataResult.error(() -> "Cannot create EntryStackFavoriteEntry from empty args!");
            }
            Object object = args[0];
            if (!(object instanceof EntryStack)) {
                return DataResult.error(() -> "Creation of EntryStackFavoriteEntry from args expected EntryStack as the first argument!");
            }
            EntryStack stack = (EntryStack)object;
            if (!stack.supportSaving()) {
                return DataResult.error(() -> "Creation of EntryStackFavoriteEntry from an unserializable stack!");
            }
            return DataResult.success((Object)new EntryStackFavoriteEntry(stack), (Lifecycle)Lifecycle.stable());
        }

        @Override
        public CompoundTag save(EntryStackFavoriteEntry entry, CompoundTag tag) {
            tag.m_128365_("data", (Tag)entry.stack.saveStack());
            return tag;
        }
    }

    private static class EntryStackFavoriteEntry
    extends FavoriteEntry {
        private static final Function<EntryStack<?>, String> CANCEL_FLUID_AMOUNT = s -> null;
        private final EntryStack<?> stack;
        private final long hash;

        public EntryStackFavoriteEntry(EntryStack<?> stack) {
            this.stack = stack.normalize();
            this.hash = EntryStacks.hashExact(this.stack);
        }

        @Override
        public boolean isInvalid() {
            return this.stack.isEmpty();
        }

        @Override
        public Renderer getRenderer(boolean showcase) {
            return this.stack;
        }

        @Override
        public boolean doAction(int button) {
            return false;
        }

        @Override
        public long hashIgnoreAmount() {
            return this.hash;
        }

        @Override
        public FavoriteEntry copy() {
            return new EntryStackFavoriteEntry(this.stack.normalize());
        }

        @Override
        public ResourceLocation getType() {
            return EntryStackFavoriteType.INSTANCE.id;
        }

        @Override
        public boolean isSame(FavoriteEntry other) {
            if (!(other instanceof EntryStackFavoriteEntry)) {
                return false;
            }
            EntryStackFavoriteEntry that = (EntryStackFavoriteEntry)other;
            return EntryStacks.equalsExact(this.stack, that.stack);
        }
    }
}

