/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.mixin.forge;

import dev.architectury.utils.GameInstance;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.ChatFormatting;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketEncoder.class})
public class MixinPacketEncoder {
    @Inject(method={"encode"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/protocol/Packet;isSkippable()Z")})
    private void failedToEncode(ChannelHandlerContext channelHandlerContext, Packet<?> packet, ByteBuf byteBuf, CallbackInfo ci) {
        if (packet instanceof ClientboundUpdateRecipesPacket) {
            MinecraftServer server = GameInstance.getServer();
            String issue = "REI: Server failed to synchronize recipe data with the client! Please check the server console log for errors, this breaks REI and vanilla recipe books!";
            server.execute(() -> {
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    player.m_213846_((Component)Component.m_237113_((String)issue).m_130940_(ChatFormatting.RED));
                }
            });
            System.out.println(issue);
        }
    }
}

