/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search;

import com.google.common.collect.Lists;
import dev.architectury.platform.Platform;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.search.SearchFilter;
import me.shedaniel.rei.api.client.search.SearchProvider;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.util.ThreadCreator;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.Util;

public class AsyncSearchManager {
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadCreator("REI-AsyncSearchManager").asService(Math.min(3, Runtime.getRuntime().availableProcessors()));
    private final Supplier<List<? extends HashedEntryStackWrapper>> stacksProvider;
    private final Supplier<Predicate<HashedEntryStackWrapper>> additionalPredicateSupplier;
    private final UnaryOperator<HashedEntryStackWrapper> transformer;
    private volatile Map.Entry<List<HashedEntryStackWrapper>, SearchFilter> last;
    public volatile ExecutorTuple executor;
    public volatile SearchFilter filter;

    public AsyncSearchManager(Supplier<List<? extends HashedEntryStackWrapper>> stacksProvider, Supplier<Predicate<HashedEntryStackWrapper>> additionalPredicateSupplier, UnaryOperator<HashedEntryStackWrapper> transformer) {
        this.stacksProvider = stacksProvider;
        this.additionalPredicateSupplier = additionalPredicateSupplier;
        this.transformer = transformer;
    }

    public void markDirty() {
        this.last = null;
    }

    public void updateFilter(String filter) {
        if (this.filter == null || !this.filter.getFilter().equals(filter)) {
            if (this.executor != null) {
                this.executor.future().cancel(Platform.isFabric());
            }
            this.executor = null;
            this.filter = SearchProvider.getInstance().createFilter(filter);
        }
    }

    public boolean isDirty() {
        return this.last == null || this.last.getValue() != this.filter;
    }

    public Future<?> getAsync(BiConsumer<List<HashedEntryStackWrapper>, SearchFilter> consumer) {
        if (this.executor == null || this.executor.filter() != this.filter || this.isDirty()) {
            if (this.executor != null) {
                this.executor.future().cancel(Platform.isFabric());
            }
            Steps steps = new Steps();
            this.executor = new ExecutorTuple(this.filter, this.get(EXECUTOR_SERVICE, steps), steps);
        }
        SearchFilter savedFilter = this.filter;
        this.executor = new ExecutorTuple(this.executor.filter(), (CompletableFuture<Map.Entry<List<HashedEntryStackWrapper>, SearchFilter>>)this.executor.future().thenApplyAsync(result -> {
            if (savedFilter == this.filter) {
                consumer.accept((List)result.getKey(), (SearchFilter)result.getValue());
            }
            return result;
        }, (Executor)EXECUTOR_SERVICE), this.executor.steps);
        return this.executor.future();
    }

    public List<HashedEntryStackWrapper> getNow() {
        try {
            return this.get(Runnable::run, new Steps()).get().getKey();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException | CancellationException e) {
            return Lists.newArrayList();
        }
    }

    public CompletableFuture<Map.Entry<List<HashedEntryStackWrapper>, SearchFilter>> get(Executor executor, Steps steps) {
        if (this.isDirty()) {
            Map.Entry<List<HashedEntryStackWrapper>, SearchFilter> last = this.last;
            return AsyncSearchManager.get(this.filter, this.additionalPredicateSupplier.get(), this.transformer, this.stacksProvider.get(), last, this, executor, steps).thenApply(entry -> {
                this.last = entry;
                return entry;
            });
        }
        return CompletableFuture.completedFuture(this.last);
    }

    public static CompletableFuture<Map.Entry<List<HashedEntryStackWrapper>, SearchFilter>> get(SearchFilter filter, Predicate<HashedEntryStackWrapper> additionalPredicate, UnaryOperator<HashedEntryStackWrapper> transformer, List<? extends HashedEntryStackWrapper> stacks, Map.Entry<List<HashedEntryStackWrapper>, SearchFilter> last, AsyncSearchManager manager, Executor executor, Steps steps) {
        int searchPartitionSize = ConfigObject.getInstance().getAsyncSearchPartitionSize();
        boolean shouldAsync = ConfigObject.getInstance().shouldAsyncSearch() && stacks.size() > searchPartitionSize * 4;
        InternalLogger.getInstance().debug("Starting Search: \"" + filter.getFilter() + "\" with " + stacks.size() + " stacks, shouldAsync: " + shouldAsync + " on " + Thread.currentThread().getName());
        if (!stacks.isEmpty()) {
            if (shouldAsync) {
                ArrayList futures = Lists.newArrayList();
                int partitions = 0;
                for (Iterable iterable : CollectionUtils.partition(stacks, searchPartitionSize * 4)) {
                    int finalPartitions = partitions++;
                    futures.add(CompletableFuture.supplyAsync(() -> {
                        ArrayList filtered = Lists.newArrayList();
                        if (manager.filter != filter) {
                            throw new CancellationException();
                        }
                        for (HashedEntryStackWrapper stack : partitionStacks) {
                            if (stack != null && AsyncSearchManager.test(filter, stack.unwrap(), stack.hashExact()) && additionalPredicate.test(stack)) {
                                filtered.add((HashedEntryStackWrapper)transformer.apply(stack));
                            }
                            if (manager.filter == filter) continue;
                            throw new CancellationException();
                        }
                        steps.partitionsDone.incrementAndGet();
                        return filtered;
                    }, executor));
                }
                steps.startTime = Util.m_137574_();
                steps.totalPartitions = partitions;
                InternalLogger.getInstance().debug("Async Search: " + partitions + " partitions for \"" + filter.getFilter() + "\"");
                return ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).orTimeout(90L, TimeUnit.SECONDS).thenApplyAsync($ -> {
                    ArrayList list = new ArrayList();
                    for (CompletableFuture future : futures) {
                        List now = future.getNow(null);
                        if (now == null) continue;
                        list.addAll(now);
                    }
                    if (manager.filter != filter) {
                        throw new CancellationException();
                    }
                    return list;
                }, executor)).thenApply(result -> new AbstractMap.SimpleImmutableEntry<List, SearchFilter>((List)result, filter));
            }
            ArrayList<HashedEntryStackWrapper> list = new ArrayList<HashedEntryStackWrapper>();
            for (HashedEntryStackWrapper hashedEntryStackWrapper : stacks) {
                if (AsyncSearchManager.test(filter, hashedEntryStackWrapper.unwrap(), hashedEntryStackWrapper.hashExact()) && additionalPredicate.test(hashedEntryStackWrapper)) {
                    list.add((HashedEntryStackWrapper)transformer.apply(hashedEntryStackWrapper));
                }
                if (manager.filter == filter) continue;
                throw new CancellationException();
            }
            return CompletableFuture.completedFuture(new AbstractMap.SimpleImmutableEntry(list, filter));
        }
        return CompletableFuture.completedFuture(new AbstractMap.SimpleImmutableEntry<ArrayList, SearchFilter>(Lists.newArrayList(), filter));
    }

    private static boolean test(SearchFilter filter, EntryStack<?> stack, long hashExact) {
        try {
            return filter.test(stack, hashExact);
        }
        catch (Throwable throwable) {
            InternalLogger.getInstance().debug("Error while testing filter", throwable);
            return false;
        }
    }

    public boolean matches(EntryStack<?> stack) {
        return this.filter.test(stack);
    }

    public record ExecutorTuple(SearchFilter filter, CompletableFuture<Map.Entry<List<HashedEntryStackWrapper>, SearchFilter>> future, Steps steps) {
    }

    public static class Steps {
        public long startTime = 0L;
        public AtomicInteger partitionsDone = new AtomicInteger(0);
        public int totalPartitions = 0;
    }
}

