/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.hint;

import com.google.gson.Gson;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.impl.client.gui.widget.hint.HintWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.FormattedText;

public class HintsContainerWidget
extends DelegateWidget {
    private final List<HintWidget> hints = new ArrayList<HintWidget>();
    private final Widget delegate = Widgets.concat(this.hints);
    private HintsConfig config;

    public HintsContainerWidget() {
        super(Widgets.noOp());
        this.read();
    }

    public void init() {
        for (HintWidget hint : this.hints) {
            hint.recalculateBounds();
        }
    }

    @Override
    protected Widget delegate() {
        return this.delegate;
    }

    public void addHint(int margin, Supplier<Point> point, String uuid, Collection<? extends FormattedText> lines) {
        if (this.config.shownHints.add(uuid)) {
            this.hints.removeIf(hintWidget -> hintWidget.getUuid().equals(uuid));
            this.hints.add(new HintWidget(this, margin, point, uuid, lines));
            this.write();
        }
    }

    void removeHint(HintWidget hintWidget) {
        this.hints.remove(hintWidget);
    }

    public void read() {
        Path path = Platform.getConfigFolder().resolve("roughlyenoughitems/hints.json");
        this.config = new HintsConfig();
        String uuid = Minecraft.m_91087_().m_91094_().m_92545_();
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
                this.config = (HintsConfig)new Gson().fromJson((Reader)reader, HintsConfig.class);
                if (!uuid.equals(this.config.UUID)) {
                    this.config = new HintsConfig();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.config = new HintsConfig();
            }
        }
        this.config.UUID = uuid;
        this.write();
    }

    public void write() {
        Path path = Platform.getConfigFolder().resolve("roughlyenoughitems/hints.json");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            new Gson().toJson((Object)this.config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class HintsConfig {
        private String UUID;
        private Set<String> shownHints = new LinkedHashSet<String>();

        private HintsConfig() {
        }
    }
}

