/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.history;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayEntry;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryWidget;
import me.shedaniel.rei.impl.client.registry.display.DisplayKey;
import me.shedaniel.rei.impl.client.registry.display.DisplaysHolder;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DisplayHistoryManager {
    public static final DisplayHistoryManager INSTANCE = new DisplayHistoryManager();
    private Map<String, DisplayEntry> entries = new LinkedHashMap<String, DisplayEntry>();
    private final Map<Display, DisplayEntry> displayToEntries = new Reference2ObjectLinkedOpenHashMap();
    private long lastCheckTime = -1L;

    @Nullable
    public Object getPossibleOrigin(DisplaysHolder holder, Display display) {
        DisplayEntry entry = this.displayToEntries.get(display);
        if (entry == null) {
            return null;
        }
        Optional<ResourceLocation> location = display.getDisplayLocation();
        if (location.isEmpty()) {
            return null;
        }
        Set<Display> displays = holder.getDisplaysByKey(DisplayKey.create(display.getCategoryIdentifier(), location.get()));
        for (Display d : displays) {
            Object origin;
            if (this.displayToEntries.containsKey(d) || (origin = holder.getDisplayOrigin(d)) == null) continue;
            return origin;
        }
        return null;
    }

    public Map<Display, DisplayEntry> getDisplayToEntries() {
        return this.displayToEntries;
    }

    public Collection<DisplayEntry> getEntries(DisplayHistoryWidget parent) {
        if (!(this.lastCheckTime != -1L && Util.m_137550_() - this.lastCheckTime <= 4000L || PluginManager.areAnyReloading())) {
            this.updateEntries(parent);
            this.lastCheckTime = Util.m_137550_();
        }
        return Collections.unmodifiableCollection(this.entries.values());
    }

    private void updateEntries(DisplayHistoryWidget parent) {
        List<CompoundTag> displayHistory = ConfigManagerImpl.getInstance().getConfig().getDisplayHistory();
        LinkedHashMap<String, DisplayEntry> copy = new LinkedHashMap<String, DisplayEntry>(this.entries);
        this.entries.clear();
        this.displayToEntries.clear();
        for (CompoundTag tag : displayHistory) {
            String uuid = tag.m_128461_("DisplayHistoryUUID");
            DisplayEntry entry = (DisplayEntry)copy.get(uuid);
            if (entry != null) {
                this.entries.put(entry.getUuid().toString(), entry);
                this.displayToEntries.put(entry.getDisplay(), entry);
                continue;
            }
            if (!tag.m_128471_("DisplayHistoryContains")) continue;
            try {
                CategoryIdentifier categoryIdentifier = CategoryIdentifier.of(tag.m_128461_("DisplayHistoryCategory"));
                if (!CategoryRegistry.getInstance().tryGet(categoryIdentifier).isPresent()) continue;
                Object display = DisplaySerializerRegistry.getInstance().read(categoryIdentifier, tag.m_128469_("DisplayHistoryData"));
                DisplayEntry newEntry = new DisplayEntry(parent, (Display)display, null);
                newEntry.setUuid(UUID.fromString(uuid));
                this.entries.put(newEntry.getUuid().toString(), newEntry);
                this.displayToEntries.put(newEntry.getDisplay(), newEntry);
            }
            catch (Exception e) {
                InternalLogger.getInstance().warn("Failed to read display history entry", e);
            }
        }
    }

    public void removeEntry(DisplayEntry entry) {
        this.entries.remove(entry.getUuid().toString());
        this.displayToEntries.remove(entry.getDisplay());
        List<CompoundTag> displayHistory = ConfigManagerImpl.getInstance().getConfig().getDisplayHistory();
        displayHistory.removeIf(tag -> tag.m_128461_("DisplayHistoryUUID").equals(entry.getUuid().toString()));
        this.save();
    }

    public void addEntry(DisplayHistoryWidget parent, @Nullable Rectangle bounds, Display display) {
        List<CompoundTag> displayHistory = ConfigManagerImpl.getInstance().getConfig().getDisplayHistory();
        Iterator<DisplayEntry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            DisplayEntry entry = iterator.next();
            if (entry.getDisplay() != display) continue;
            displayHistory.removeIf(tag -> tag.m_128461_("DisplayHistoryUUID").equals(entry.getUuid().toString()));
            this.displayToEntries.remove(entry.getDisplay());
            iterator.remove();
        }
        DisplayEntry newEntry = new DisplayEntry(parent, display, bounds);
        LinkedHashMap<String, DisplayEntry> copy = new LinkedHashMap<String, DisplayEntry>();
        copy.put(newEntry.getUuid().toString(), newEntry);
        copy.putAll(this.entries);
        this.entries = copy;
        this.displayToEntries.clear();
        for (DisplayEntry entry : this.entries.values()) {
            this.displayToEntries.put(entry.getDisplay(), entry);
        }
        while (this.entries.size() >= 10) {
            DisplayEntry entry = (DisplayEntry)Iterables.get(this.entries.values(), (int)(this.entries.size() - 1));
            displayHistory.removeIf(tag -> tag.m_128461_("DisplayHistoryUUID").equals(entry.getUuid().toString()));
            this.entries.remove(entry.getUuid().toString());
            this.displayToEntries.remove(entry.getDisplay());
        }
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128379_("DisplayHistoryContains", false);
        compoundTag.m_128359_("DisplayHistoryUUID", newEntry.getUuid().toString());
        compoundTag.m_128359_("DisplayHistoryCategory", display.getCategoryIdentifier().toString());
        displayHistory.add(0, compoundTag);
        this.save();
    }

    private void save() {
        List<CompoundTag> displayHistory = ConfigManagerImpl.getInstance().getConfig().getDisplayHistory();
        for (CompoundTag compoundTag : displayHistory) {
            String uuid = compoundTag.m_128461_("DisplayHistoryUUID");
            DisplayEntry entry = this.entries.get(uuid);
            if (entry == null) continue;
            compoundTag.m_128379_("DisplayHistoryContains", false);
            Display display = entry.getDisplay();
            boolean hasSerializer = DisplaySerializerRegistry.getInstance().hasSerializer(display.getCategoryIdentifier());
            if (!hasSerializer) continue;
            try {
                compoundTag.m_128365_("DisplayHistoryData", (Tag)DisplaySerializerRegistry.getInstance().save(display, new CompoundTag()));
                compoundTag.m_128379_("DisplayHistoryContains", true);
            }
            catch (Exception e) {
                InternalLogger.getInstance().warn("Failed to save display history entry", e);
            }
        }
        ConfigManagerImpl.getInstance().saveConfig();
    }
}

