/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.forge;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import me.shedaniel.rei.impl.common.InternalLogger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class CreativeModeTabCollectorImpl {
    public static Map<CreativeModeTab, Collection<ItemStack>> collectTabs() {
        LinkedHashMap<CreativeModeTab, Collection<ItemStack>> map = new LinkedHashMap<CreativeModeTab, Collection<ItemStack>>();
        FeatureFlagSet featureFlags = FeatureFlags.f_244280_.m_247355_();
        CreativeModeTab.ItemDisplayParameters parameters = new CreativeModeTab.ItemDisplayParameters(featureFlags, true, (HolderLookup.Provider)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_));
        for (CreativeModeTab tab : CreativeModeTabs.m_257478_()) {
            if (tab.m_257962_() == CreativeModeTab.Type.HOTBAR || tab.m_257962_() == CreativeModeTab.Type.INVENTORY) continue;
            try {
                CreativeModeTab.ItemDisplayBuilder builder = new CreativeModeTab.ItemDisplayBuilder(tab, featureFlags);
                ResourceKey resourceKey = (ResourceKey)BuiltInRegistries.f_279662_.m_7854_((Object)tab).orElseThrow(() -> new IllegalStateException("Unregistered creative tab: " + tab));
                ForgeHooksClient.onCreativeModeTabBuildContents((CreativeModeTab)tab, (ResourceKey)resourceKey, (CreativeModeTab.DisplayItemsGenerator)tab.f_256824_, (CreativeModeTab.ItemDisplayParameters)parameters, (stack, visibility) -> {
                    if (visibility == CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY) {
                        return;
                    }
                    builder.m_246267_(stack, visibility);
                });
                map.put(tab, builder.f_244363_);
            }
            catch (Throwable throwable) {
                InternalLogger.getInstance().error("Failed to collect creative tab: " + tab, throwable);
            }
        }
        return map;
    }
}

