/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.filtering.FilteringRule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public abstract class FilteringRuleOptionsScreen<T extends FilteringRule<?>>
extends Screen {
    private RulesList rulesList;
    Screen parent;
    public T rule;

    public FilteringRuleOptionsScreen(T rule, Screen screen) {
        super((Component)Component.m_237115_((String)"config.roughlyenoughitems.filteringRulesScreen"));
        this.rule = rule;
        this.parent = screen;
    }

    public void m_7856_() {
        super.m_7856_();
        if (this.rulesList != null) {
            this.save();
        }
        MutableComponent doneText = Component.m_237115_((String)"gui.done");
        int width = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)doneText);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ - 4 - width - 10, 4, width + 10, 20, (Component)doneText, button -> {
            this.save();
            this.f_96541_.m_91152_(this.parent);
        }, Supplier::get){});
        this.rulesList = (RulesList)this.m_7787_((GuiEventListener)new RulesList(this.f_96541_, this.f_96543_, this.f_96544_, 30, this.f_96544_, f_279548_));
        this.addEntries(ruleEntry -> this.rulesList.addItem((RuleEntry)((Object)ruleEntry)));
    }

    public abstract void addEntries(Consumer<RuleEntry> var1);

    public abstract void save();

    public void addText(Consumer<RuleEntry> entryConsumer, FormattedText text) {
        for (FormattedCharSequence s : this.f_96547_.m_92923_(text, this.f_96543_ - 80)) {
            entryConsumer.accept(new TextRuleEntry((FilteringRule<?>)this.rule, s));
        }
    }

    public void addEmpty(Consumer<RuleEntry> entryConsumer, int height) {
        entryConsumer.accept(new EmptyRuleEntry((FilteringRule<?>)this.rule, height));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.rulesList.m_88315_(graphics, mouseX, mouseY, delta);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280648_(this.f_96547_, this.f_96539_.m_7532_(), (int)((float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f), 12, -1);
    }

    public static class RulesList
    extends DynamicElementListWidget<RuleEntry> {
        public RulesList(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
        }

        protected int addItem(RuleEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    public static class TextRuleEntry
    extends RuleEntry {
        private final FormattedCharSequence text;

        public TextRuleEntry(FilteringRule<?> rule, FormattedCharSequence text) {
            super(rule);
            this.text = text;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            graphics.m_280648_(Minecraft.m_91087_().f_91062_, this.text, x + 5, y, -1);
        }

        public int getItemHeight() {
            return 12;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static class EmptyRuleEntry
    extends RuleEntry {
        private final int height;

        public EmptyRuleEntry(FilteringRule<?> rule, int height) {
            super(rule);
            this.height = height;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        }

        public int getItemHeight() {
            return this.height;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static abstract class RuleEntry
    extends DynamicElementListWidget.ElementEntry<RuleEntry> {
        private final FilteringRule<?> rule;

        public RuleEntry(FilteringRule<?> rule) {
            this.rule = rule;
        }

        public FilteringRule<?> getRule() {
            return this.rule;
        }
    }

    public static class SubRulesEntry
    extends RuleEntry {
        private static final ResourceLocation CONFIG_TEX = new ResourceLocation("cloth-config2", "textures/gui/cloth_config.png");
        private final CategoryLabelWidget widget;
        private final List<RuleEntry> rules;
        private final List<GuiEventListener> children;
        private boolean expanded;
        private Supplier<Component> name;

        public SubRulesEntry(FilteringRule<?> rule, Supplier<Component> name, List<RuleEntry> rules) {
            super(rule);
            this.rules = rules;
            this.widget = new CategoryLabelWidget();
            this.name = name;
            this.expanded = true;
            this.children = new ArrayList<RuleEntry>(rules);
            this.children.add(this.widget);
        }

        public List<RuleEntry> getRules() {
            return this.rules;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CONFIG_TEX);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.widget.rectangle.x = x + 3;
            this.widget.rectangle.y = y;
            this.widget.rectangle.width = entryWidth - 6;
            this.widget.rectangle.height = 24;
            graphics.m_280218_(CONFIG_TEX, x + 3, y + 5, 24, (this.widget.rectangle.contains(mouseX, mouseY) ? 18 : 0) + (this.expanded ? 9 : 0), 9, 9);
            graphics.m_280648_(Minecraft.m_91087_().f_91062_, this.name.get().m_7532_(), x + 3 + 15, y + 6, this.widget.rectangle.contains(mouseX, mouseY) ? -1638890 : -1);
            for (RuleEntry performanceEntry : this.rules) {
                performanceEntry.setParent(this.getParent());
            }
            if (this.expanded) {
                int yy = y + 24;
                for (RuleEntry entry : this.rules) {
                    entry.render(graphics, -1, yy, x + 3 + 15, entryWidth - 15 - 3, entry.getItemHeight(), mouseX, mouseY, isHovered && this.m_7222_() == entry, delta);
                    yy += entry.getItemHeight();
                }
            }
        }

        public int getMorePossibleHeight() {
            if (!this.expanded) {
                return -1;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            int i = 24;
            for (RuleEntry entry : this.rules) {
                i += entry.getItemHeight();
                if (entry.getMorePossibleHeight() < 0) continue;
                list.add(i + entry.getMorePossibleHeight());
            }
            list.add(i);
            return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
        }

        public int getItemHeight() {
            if (!this.expanded) {
                return 24;
            }
            int i = 24;
            for (RuleEntry entry : this.rules) {
                i += entry.getItemHeight();
            }
            return i;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }

        public class CategoryLabelWidget
        implements GuiEventListener {
            private final Rectangle rectangle = new Rectangle();

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (this.rectangle.contains(mouseX, mouseY)) {
                    SubRulesEntry.this.expanded = !SubRulesEntry.this.expanded;
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    return true;
                }
                return false;
            }

            @Nullable
            public ComponentPath m_264064_(FocusNavigationEvent event) {
                return null;
            }

            public void m_93692_(boolean bl) {
            }

            public boolean m_93696_() {
                return false;
            }
        }
    }

    public static class BooleanRuleEntry
    extends RuleEntry {
        private boolean b;
        private final Button widget;

        public BooleanRuleEntry(int width, boolean b, FilteringRule<?> rule, Function<Boolean, Component> textFunction) {
            super(rule);
            this.b = b;
            this.widget = new Button(0, 0, 100, 20, textFunction.apply(b), button -> {
                this.b = !this.b;
                button.m_93666_((Component)textFunction.apply(this.b));
            }, Supplier::get){};
        }

        public boolean getBoolean() {
            return this.b;
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            this.widget.m_252865_(x + 2);
            this.widget.m_253211_(y);
            this.widget.m_88315_(graphics, mouseX, mouseY, delta);
        }

        public int getItemHeight() {
            return 20;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.widget);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.singletonList(this.widget);
        }
    }

    public static class TextFieldRuleEntry
    extends RuleEntry {
        private final EditBox widget;

        public TextFieldRuleEntry(int width, FilteringRule<?> rule, Consumer<EditBox> widgetConsumer) {
            super(rule);
            this.widget = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, width, 18, Component.m_130674_((String)""));
            widgetConsumer.accept(this.widget);
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            this.widget.m_252865_(x + 2);
            this.widget.m_253211_(y + 2);
            this.widget.m_88315_(graphics, mouseX, mouseY, delta);
        }

        public int getItemHeight() {
            return 20;
        }

        public EditBox getWidget() {
            return this.widget;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.widget);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.singletonList(this.widget);
        }
    }
}

