/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.config.entries;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.impl.client.config.entries.FilteringCategoriesEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class FilteringCategoriesScreen
extends Screen {
    private final FilteringCategoriesEntry entry;
    private ListWidget listWidget;
    Screen parent;

    public FilteringCategoriesScreen(FilteringCategoriesEntry entry) {
        super((Component)Component.m_237115_((String)"config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure.title"));
        this.entry = entry;
    }

    public void m_7856_() {
        super.m_7856_();
        MutableComponent backText = Component.m_237113_((String)"\u21a9 ").m_7220_((Component)Component.m_237115_((String)"gui.back"));
        this.m_142416_((GuiEventListener)new Button(4, 4, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.f_96541_.m_91152_(this.parent);
            this.parent = null;
        }, Supplier::get){});
        this.listWidget = (ListWidget)this.m_7787_((GuiEventListener)new ListWidget(this.f_96541_, this.f_96543_, this.f_96544_, 30, this.f_96544_, f_279548_));
        for (CategoryRegistry.CategoryConfiguration configuration : CategoryRegistry.getInstance()) {
            this.listWidget.addItem(new DefaultListEntry(configuration));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.listWidget.m_88315_(graphics, mouseX, mouseY, delta);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280648_(this.f_96547_, this.f_96539_.m_7532_(), (int)((float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f), 12, -1);
    }

    private static class ListWidget
    extends DynamicElementListWidget<ListEntry> {
        private boolean inFocus;

        public ListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
        }

        protected boolean isSelected(int index) {
            return false;
        }

        public ListEntry getSelectedItem() {
            return null;
        }

        protected int addItem(ListEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (super.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            ListEntry item = (ListEntry)this.getItemAtPosition(mouseX, mouseY);
            if (item != null) {
                this.client.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.selectItem((DynamicEntryListWidget.Entry)item);
                this.m_7522_((GuiEventListener)item);
                this.m_7897_(true);
                return true;
            }
            return false;
        }

        public int getItemWidth() {
            return this.width - 40;
        }

        protected int getScrollbarPosition() {
            return this.width - 14;
        }
    }

    private class DefaultListEntry
    extends ListEntry {
        private final Button toggleButton;
        private final CategoryRegistry.CategoryConfiguration<?> configuration;

        public DefaultListEntry(CategoryRegistry.CategoryConfiguration<?> configuration) {
            this.configuration = configuration;
            MutableComponent toggleText = Component.m_237115_((String)"config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure.toggle");
            this.toggleButton = new Button(0, 0, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)toggleText) + 10, 20, (Component)toggleText, button -> {
                boolean quickCraftingEnabledByDefault = configuration.isQuickCraftingEnabledByDefault();
                boolean enabled = FilteringCategoriesScreen.this.entry.getValue().getOrDefault(configuration.getCategoryIdentifier(), quickCraftingEnabledByDefault);
                if (enabled) {
                    if (!quickCraftingEnabledByDefault) {
                        FilteringCategoriesScreen.this.entry.getValue().remove(configuration.getCategoryIdentifier());
                    } else {
                        FilteringCategoriesScreen.this.entry.getValue().put(configuration.getCategoryIdentifier(), false);
                    }
                } else if (quickCraftingEnabledByDefault) {
                    FilteringCategoriesScreen.this.entry.getValue().remove(configuration.getCategoryIdentifier());
                } else {
                    FilteringCategoriesScreen.this.entry.getValue().put(configuration.getCategoryIdentifier(), true);
                }
                FilteringCategoriesScreen.this.entry.edited = true;
            }, Supplier::get){};
        }

        public void render(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
            if (y + entryHeight < 0 || y > FilteringCategoriesScreen.this.f_96544_) {
                return;
            }
            Minecraft client = Minecraft.m_91087_();
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            this.configuration.getCategory().getIcon().render(graphics, new Rectangle(x + 2, y + 5, 16, 16), mouseY, mouseY, delta);
            graphics.m_280168_().m_85849_();
            int xPos = x + 22;
            Component title = this.configuration.getCategory().getTitle();
            int i = client.f_91062_.m_92852_((FormattedText)title);
            if (i > entryWidth - 28) {
                FormattedText titleTrimmed = FormattedText.m_130773_((FormattedText[])new FormattedText[]{client.f_91062_.m_92854_((FormattedText)title, entryWidth - 28 - client.f_91062_.m_92895_("...")), FormattedText.m_130775_((String)"...")});
                graphics.m_280648_(client.f_91062_, Language.m_128107_().m_5536_(titleTrimmed), x + 2, y + 1, 0xFFFFFF);
            } else {
                graphics.m_280648_(client.f_91062_, title.m_7532_(), xPos, y + 1, 0xFFFFFF);
            }
            MutableComponent subtitle = Component.m_237115_((String)("config.roughlyenoughitems.filtering.filteringQuickCraftCategories.configure." + FilteringCategoriesScreen.this.entry.getValue().getOrDefault(this.configuration.getCategoryIdentifier(), this.configuration.isQuickCraftingEnabledByDefault()))).m_130940_(ChatFormatting.GRAY);
            i = client.f_91062_.m_92852_((FormattedText)subtitle);
            if (i > entryWidth - 28) {
                FormattedText subtitleTrimmed = FormattedText.m_130773_((FormattedText[])new FormattedText[]{client.f_91062_.m_92854_((FormattedText)subtitle, entryWidth - 28 - client.f_91062_.m_92895_("...")), FormattedText.m_130775_((String)"...")});
                graphics.m_280648_(client.f_91062_, Language.m_128107_().m_5536_(subtitleTrimmed), x + 2, y + 12, 0x808080);
            } else {
                graphics.m_280648_(client.f_91062_, subtitle.m_7532_(), xPos, y + 12, 0x808080);
            }
            MutableComponent id = Component.m_237113_((String)this.configuration.getCategoryIdentifier().toString()).m_130940_(ChatFormatting.DARK_GRAY);
            i = client.f_91062_.m_92852_((FormattedText)id);
            if (i > entryWidth - 28) {
                FormattedText idTrimmed = FormattedText.m_130773_((FormattedText[])new FormattedText[]{client.f_91062_.m_92854_((FormattedText)id, entryWidth - 28 - client.f_91062_.m_92895_("...")), FormattedText.m_130775_((String)"...")});
                graphics.m_280648_(client.f_91062_, Language.m_128107_().m_5536_(idTrimmed), x + 2, y + 22, 0x808080);
            } else {
                graphics.m_280648_(client.f_91062_, id.m_7532_(), xPos, y + 22, 0x808080);
            }
            this.toggleButton.m_252865_(x + entryWidth - 6 - this.toggleButton.m_5711_());
            this.toggleButton.m_253211_(y + 5);
            this.toggleButton.m_88315_(graphics, mouseX, mouseY, delta);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.toggleButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return Collections.singletonList(this.toggleButton);
        }
    }

    private static abstract class ListEntry
    extends DynamicElementListWidget.ElementEntry<ListEntry> {
        private ListEntry() {
        }

        public int getItemHeight() {
            return 35;
        }
    }
}

