/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry.comparison;

import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

@FunctionalInterface
public interface EntryComparator<T> {
    public static <T> EntryComparator<T> noop() {
        return (context, stack) -> 1L;
    }

    public static EntryComparator<ItemStack> itemNbt() {
        EntryComparator<Tag> nbtHasher = EntryComparator.nbt("Count");
        return (context, stack) -> {
            CompoundTag tag = stack.m_41783_();
            return tag == null ? 0L : nbtHasher.hash(context, (Tag)tag);
        };
    }

    public static EntryComparator<FluidStack> fluidNbt() {
        EntryComparator<Tag> nbtHasher = EntryComparator.nbt("Amount");
        return (context, stack) -> {
            CompoundTag tag = stack.getTag();
            return tag == null ? 0L : nbtHasher.hash(context, (Tag)tag);
        };
    }

    public static EntryComparator<Tag> nbt(String ... ignoredKeys) {
        return Internals.getNbtHasher(ignoredKeys);
    }

    public long hash(ComparisonContext var1, T var2);

    default public EntryComparator<T> onlyExact() {
        EntryComparator self = this;
        return (context, stack) -> context.isExact() ? self.hash(context, stack) : 1L;
    }

    default public EntryComparator<T> then(EntryComparator<T> other) {
        Objects.requireNonNull(other);
        EntryComparator self = this;
        return (context, stack) -> {
            long hash = 1L;
            hash = hash * 31L + self.hash(context, stack);
            hash = hash * 31L + other.hash(context, stack);
            return hash;
        };
    }
}

