/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.hands;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.registry.ModGameRules;
import artifacts.util.DamageSourceHelper;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;

public class PocketPistonItem
extends WearableArtifactItem {
    public PocketPistonItem() {
        EntityEvent.LIVING_HURT.register(this::onLivingHurt);
    }

    @Override
    protected boolean isCosmetic() {
        return ModGameRules.POCKET_PISTON_KNOCKBACK_STRENGTH.get() <= 0;
    }

    private EventResult onLivingHurt(LivingEntity entity, DamageSource damageSource, float amount) {
        LivingEntity attacker = DamageSourceHelper.getAttacker(damageSource);
        if (attacker != null && this.isEquippedBy(attacker)) {
            float knockbackBonus = Math.max(0.0f, (float)ModGameRules.POCKET_PISTON_KNOCKBACK_STRENGTH.get().intValue() / 10.0f);
            entity.m_147240_((double)knockbackBonus, (double)Mth.m_14031_((float)((float)((double)attacker.m_146908_() * (Math.PI / 180)))), (double)(-Mth.m_14089_((float)((float)((double)attacker.m_146908_() * (Math.PI / 180))))));
        }
        return EventResult.pass();
    }

    @Override
    public SoundEvent getEquipSound() {
        return SoundEvents.f_12312_;
    }
}

