/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.hands;

import artifacts.item.wearable.WearableArtifactItem;
import artifacts.platform.PlatformServices;
import artifacts.registry.ModGameRules;
import artifacts.registry.ModItems;
import artifacts.registry.ModTags;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.state.BlockState;

public class DiggingClawsItem
extends WearableArtifactItem {
    @Override
    protected boolean isCosmetic() {
        return ModGameRules.DIGGING_CLAWS_TOOL_TIER.get() <= 0 && ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get() <= 0;
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        int tierLevel = DiggingClawsItem.getToolTierLevel();
        if (tierLevel > 0) {
            tooltip.add(this.tooltipLine("mining_level", Component.m_237115_((String)"%s.tooltip.tool_tier.%s".formatted("artifacts", tierLevel))));
        }
        if (ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get() > 0) {
            tooltip.add(this.tooltipLine("mining_speed", new Object[0]));
        }
    }

    public static int getToolTierLevel() {
        return Math.min(5, Math.max(0, ModGameRules.DIGGING_CLAWS_TOOL_TIER.get()));
    }

    public static Tier getToolTier() {
        return switch (DiggingClawsItem.getToolTierLevel()) {
            case 0 -> null;
            case 1 -> Tiers.WOOD;
            case 2 -> Tiers.STONE;
            case 3 -> Tiers.IRON;
            case 4 -> Tiers.DIAMOND;
            default -> Tiers.NETHERITE;
        };
    }

    public static boolean canDiggingClawsHarvest(LivingEntity entity, BlockState state) {
        if (ModItems.DIGGING_CLAWS.get().isEquippedBy(entity)) {
            Tier tier = DiggingClawsItem.getToolTier();
            return tier != null && PlatformServices.platformHelper.isCorrectTierForDrops(tier, state) && state.m_204336_(ModTags.MINEABLE_WITH_DIGGING_CLAWS);
        }
        return false;
    }

    public static float getSpeedBonus(Player player, BlockState state) {
        if (ModItems.DIGGING_CLAWS.get().isEquippedBy((LivingEntity)player) && player.m_36298_(state)) {
            return Math.max(0.0f, (float)ModGameRules.DIGGING_CLAWS_DIG_SPEED_BONUS.get().intValue() / 10.0f);
        }
        return 0.0f;
    }

    @Override
    public SoundEvent getEquipSound() {
        return SoundEvents.f_11679_;
    }
}

