/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component;

import artifacts.component.SwimData;
import artifacts.item.wearable.necklace.CharmOfSinkingItem;
import artifacts.platform.PlatformServices;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SwimEventHandler {
    public static void register() {
        TickEvent.PLAYER_PRE.register(SwimEventHandler::onPlayerTick);
    }

    private static void onPlayerTick(Player player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
        if (swimData != null) {
            if (player.m_20069_() || player.m_20077_()) {
                if (!swimData.isWet()) {
                    swimData.setWet(true);
                }
            } else if (player.m_20096_() || player.m_150110_().f_35935_) {
                swimData.setWet(false);
            }
        }
    }

    public static EventResult onPlayerSwim(Player player) {
        SwimData swimData = PlatformServices.platformHelper.getSwimData((LivingEntity)player);
        if (swimData != null) {
            if (swimData.isSwimming()) {
                return EventResult.interruptTrue();
            }
            if (CharmOfSinkingItem.shouldSink((LivingEntity)player)) {
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }
}

