/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.block.tile.GhostWeaveTile;
import com.hollingsworth.arsnouveau.common.block.tile.SpellSensorTile;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectInvisibility;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_nouveau")
public class ArsEvents {
    @SubscribeEvent
    public static void costCalc(SpellCostCalcEvent e) {
        if (e.context.getCasterTool().m_41619_()) {
            return;
        }
        IWrappedCaster iWrappedCaster = e.context.getCaster();
        if (iWrappedCaster instanceof PlayerCaster) {
            PlayerCaster livingCaster = (PlayerCaster)iWrappedCaster;
            if (e.context.getCasterTool().m_150930_((Item)ItemsRegistry.CASTER_TOME.get())) {
                int maxMana = ManaUtil.getMaxMana(livingCaster.player);
                e.currentCost = e.currentCost > maxMana ? maxMana : (e.currentCost /= 2);
            }
        }
    }

    @SubscribeEvent
    public static void castEvent(SpellCastEvent castEvent) {
        SpellSensorTile.onSpellCast(castEvent);
    }

    @SubscribeEvent
    public static void regenCalc(ManaRegenCalcEvent e) {
        if (e.getEntity() != null && e.getEntity().m_21023_((MobEffect)ModPotions.HEX_EFFECT.get())) {
            e.setRegen(e.getRegen() / 2.0);
        }
    }

    @SubscribeEvent
    public static void spellResolve(SpellResolveEvent.Post e) {
        BlockHitResult blockHitResult;
        BlockEntity blockEntity;
        HitResult hitResult;
        SpellSensorTile.onSpellResolve(e);
        if (e.spell.recipe.contains(EffectInvisibility.INSTANCE) && (hitResult = e.rayTraceResult) instanceof BlockHitResult && (blockEntity = e.world.m_7702_((blockHitResult = (BlockHitResult)hitResult).m_82425_())) instanceof GhostWeaveTile) {
            GhostWeaveTile ghostWeaveTile = (GhostWeaveTile)blockEntity;
            ghostWeaveTile.setVisibility(true);
        }
    }

    @SubscribeEvent
    public static void dispelEvent(DispelEvent e) {
        BlockHitResult blockHitResult;
        HitResult hitResult = e.rayTraceResult;
        if (hitResult instanceof BlockHitResult && (hitResult = e.world.m_7702_((blockHitResult = (BlockHitResult)hitResult).m_82425_())) instanceof GhostWeaveTile) {
            GhostWeaveTile ghostWeaveTile = (GhostWeaveTile)hitResult;
            ghostWeaveTile.setVisibility(false);
        }
    }

    @SubscribeEvent
    public static void modifyItemAttributes(ItemAttributeModifierEvent event) {
        if (event.getItemStack().m_41793_()) {
            Item item = event.getItemStack().m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                if (event.getSlotType() != armor.m_40402_()) {
                    return;
                }
            }
            if (event.getItemStack().m_41720_() instanceof ShieldItem && event.getSlotType() != EquipmentSlot.OFFHAND) {
                return;
            }
            if (event.getItemStack().getEnchantmentLevel((Enchantment)EnchantmentRegistry.MANA_BOOST_ENCHANTMENT.get()) > 0) {
                event.addModifier((Attribute)PerkAttributes.MAX_MANA.get(), new AttributeModifier(UUID.fromString("f2239f81-4253-42a1-b596-234f42675484"), "max_mana_enchant", (double)((Integer)ServerConfig.MANA_BOOST_BONUS.get() * event.getItemStack().getEnchantmentLevel((Enchantment)EnchantmentRegistry.MANA_BOOST_ENCHANTMENT.get())), AttributeModifier.Operation.ADDITION));
            }
            if (event.getItemStack().getEnchantmentLevel((Enchantment)EnchantmentRegistry.MANA_REGEN_ENCHANTMENT.get()) > 0) {
                event.addModifier((Attribute)PerkAttributes.MANA_REGEN_BONUS.get(), new AttributeModifier(UUID.fromString("1024a8dd-a341-43c1-a6e4-0765032dc14c"), "mana_regen_enchant", (double)((Integer)ServerConfig.MANA_REGEN_ENCHANT_BONUS.get() * event.getItemStack().getEnchantmentLevel((Enchantment)EnchantmentRegistry.MANA_REGEN_ENCHANTMENT.get())), AttributeModifier.Operation.ADDITION));
            }
        }
    }
}

