/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.better_totem_of_undying;

import com.cerbon.better_totem_of_undying.client.TotemCuriosRenderer;
import com.cerbon.better_totem_of_undying.config.BTUCommonConfigs;
import com.cerbon.better_totem_of_undying.utils.BTUUtils;
import com.mojang.logging.LogUtils;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="better_totem_of_undying")
public class BetterTotemOfUndying {
    public static final Logger LOGGER = LogUtils.getLogger();

    public BetterTotemOfUndying() {
        if (BTUUtils.isModLoaded("curios")) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
            LOGGER.debug("Enqueued IMC to {}", (Object)"curios");
        }
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addGenericListener(ItemStack.class, this::attachCaps);
        forgeEventBus.register((Object)this);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::clientSetupEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BTUCommonConfigs.SPEC, "better_totem_of_undying.toml");
    }

    private void attachCaps(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack itemStack;
        Item item;
        if (BTUUtils.isModLoaded("curios") && (item = (itemStack = (ItemStack)event.getObject()).m_41720_()).equals(Items.f_42747_)) {
            event.addCapability(new ResourceLocation("better_totem_of_undying", "curios"), new ICapabilityProvider(){
                final ICurio curio = new ICurio(){

                    public boolean canEquipFromUse(SlotContext slotContext) {
                        return true;
                    }

                    public ItemStack getStack() {
                        return itemStack;
                    }
                };

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(() -> this.curio));
                }
            });
        }
    }

    private void clientSetupEvent(FMLClientSetupEvent event) {
        if (BTUUtils.isModLoaded("curios") && ((Boolean)BTUCommonConfigs.DISPLAY_TOTEM_ON_CHEST.get()).booleanValue()) {
            CuriosRendererRegistry.register((Item)Items.f_42747_, TotemCuriosRenderer::new);
        }
    }
}

