/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.mixin;

import me.cg360.mod.bridging.BridgingKeyMappings;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.raytrace.BridgingStateTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientMixin {
    @Shadow
    @Nullable
    public MultiPlayerGameMode f_91072_;
    @Shadow
    @Nullable
    public LocalPlayer f_91074_;
    @Shadow
    @Nullable
    public HitResult f_91077_;

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void onTick(CallbackInfo ci) {
        if (BridgingKeyMappings.TOGGLE_BRIDGING.m_90859_()) {
            BridgingMod.getConfig().toggleBridgingEnabled();
        }
        BridgingStateTracker.tick(this.f_91074_);
    }

    @Inject(at={@At(value="HEAD")}, method={"startUseItem()V"})
    public void onItemUse(CallbackInfo info) {
        if (!BridgingMod.getConfig().isBridgingEnabled()) {
            return;
        }
        if (this.f_91074_ == null) {
            return;
        }
        if (this.f_91077_ != null && this.f_91077_.m_6662_() != HitResult.Type.MISS) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            boolean stackSizeChanged;
            Direction dir;
            ItemStack itemStack = this.f_91074_.m_21120_(hand);
            Tuple<BlockPos, Direction> pair = BridgingStateTracker.getLastTickTarget();
            if (pair == null) continue;
            BlockPos pos = (BlockPos)pair.m_14418_();
            if (!this.f_91074_.m_36204_(pos, dir = (Direction)pair.m_14419_(), itemStack)) {
                return;
            }
            if (this.f_91072_ == null) {
                return;
            }
            double deltaY = this.f_91074_.m_20186_() - 0.01 - Vec3.m_82512_((Vec3i)pos).m_7098_();
            double clamped = Mth.m_14008_((double)deltaY, (double)-0.5, (double)0.5);
            Vec3 startPos = BridgingMod.getConfig().isSlabAssistEnabled() ? Vec3.m_82512_((Vec3i)pos).m_82520_(0.0, clamped, 0.0) : Vec3.m_82512_((Vec3i)pos);
            BlockHitResult blockHitResult = new BlockHitResult(startPos, dir, pos, true);
            int originalStackSize = itemStack.m_41613_();
            InteractionResult blockPlaceResult = this.f_91072_.m_233732_(this.f_91074_, hand, blockHitResult);
            if (!blockPlaceResult.m_19077_()) continue;
            if (!blockPlaceResult.m_19080_()) {
                return;
            }
            this.f_91074_.m_6674_(hand);
            boolean bl = stackSizeChanged = itemStack.m_41613_() != originalStackSize || this.f_91072_.m_105290_();
            if (stackSizeChanged && !itemStack.m_41619_()) {
                Minecraft.m_91087_().f_91063_.f_109055_.m_109320_(hand);
            }
            return;
        }
    }
}

