/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.draw;

import com.communi.suggestu.scena.core.registries.AbstractCustomRegistryEntry;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IInWorldStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.world.IWorldAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.VoxelShapeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DrawnWallChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final MutableComponent displayName;
    private final MutableComponent multiLineDisplayName;
    private final ResourceLocation iconName;
    private final int extensionWidth;

    DrawnWallChiselMode(MutableComponent displayName, MutableComponent multiLineDisplayName, ResourceLocation iconName, int extensionWidth) {
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
        this.extensionWidth = extensionWidth;
    }

    private static Direction.Axis getExtensionAxis(Direction hitDirection) {
        return switch (hitDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.NORTH, Direction.SOUTH -> Direction.Axis.X;
            case Direction.UP, Direction.WEST, Direction.EAST -> Direction.Axis.Z;
        };
    }

    private static Vec3i getOffsetPosition(Vec3i source, int offset, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> new Vec3i(source.m_123341_() + offset, source.m_123342_(), source.m_123343_());
            case Direction.Axis.Y -> new Vec3i(source.m_123341_(), source.m_123342_() + offset, source.m_123343_());
            case Direction.Axis.Z -> new Vec3i(source.m_123341_(), source.m_123342_(), source.m_123343_() + offset);
        };
    }

    @Override
    public boolean isSingleClickUse() {
        return false;
    }

    @Override
    public ClickProcessingState onLeftClickBy(Player playerEntity, IChiselingContext context) {
        return this.processRayTraceIntoContext(playerEntity, context, direction -> Vec3.m_82528_((Vec3i)direction.m_122424_().m_122436_()).m_82559_(StateEntrySize.current().getSizePerHalfBitScalingVector()));
    }

    @Override
    public void onStoppedLeftClicking(Player playerEntity, IChiselingContext context) {
        this.onLeftClickBy(playerEntity, context);
        context.setComplete();
        if (context.isSimulation()) {
            return;
        }
        context.getMutator().ifPresent(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
                mutator.inWorldMutableStream().filter(filter).forEach(state -> {
                    IBlockInformation currentState = state.getBlockInformation();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
        });
    }

    @Override
    public ClickProcessingState onRightClickBy(Player playerEntity, IChiselingContext context) {
        return this.processRayTraceIntoContext(playerEntity, context, direction -> Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82559_(StateEntrySize.current().getSizePerHalfBitScalingVector()));
    }

    @Override
    public void onStoppedRightClicking(Player playerEntity, IChiselingContext context) {
        this.onRightClickBy(playerEntity, context);
        context.setComplete();
        if (context.isSimulation()) {
            return;
        }
        context.getMutator().ifPresent(mutator -> {
            BlockPos heightPos;
            IBlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return;
            }
            Predicate<IStateEntryInfo> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator)).orElse(s -> true);
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.m_7500_()) {
                if (!playerEntity.m_7500_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir() && filter.test((IStateEntryInfo)state)).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().m_60734_().m_49954_()));
            }
            if (missingBitCount == 0 && (heightPos = mutator.getInWorldEndBlockPoint()).m_123342_() >= context.getWorld().m_151558_()) {
                MutableComponent component = Component.m_237110_((String)"build.tooHigh", (Object[])new Object[]{context.getWorld().m_151558_() - 1}).m_130940_(ChatFormatting.RED);
                playerEntity.m_213846_((Component)component);
            }
        });
    }

    private ClickProcessingState processRayTraceIntoContext(Player playerEntity, IChiselingContext context, Function<Direction, Vec3> offsetGenerator) {
        Optional<Direction.Axis> targetedAxis;
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return ClickProcessingState.DEFAULT;
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 currentTarget = blockRayTraceResult.m_82450_().m_82549_(offsetGenerator.apply(blockRayTraceResult.m_82434_()));
        Optional<Vec3> anchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        if (anchor.isEmpty()) {
            context.setMetadata(ModMetadataKeys.ANCHOR.get(), currentTarget);
            anchor = context.getMetadata(ModMetadataKeys.ANCHOR.get());
        }
        if ((targetedAxis = context.getMetadata(ModMetadataKeys.TARGETED_AXIS.get())).isEmpty()) {
            targetedAxis = Optional.of(DrawnWallChiselMode.getExtensionAxis(blockRayTraceResult.m_82434_()));
            context.setMetadata(ModMetadataKeys.TARGETED_AXIS.get(), targetedAxis.get());
        }
        context.resetMutator();
        context.include(anchor.orElseThrow());
        context.include(currentTarget);
        Optional<Vec3> finalAnchor = anchor;
        Optional<Direction.Axis> finalTargetedAxis = targetedAxis;
        context.setStateFilter(areaAccessor -> {
            if (areaAccessor instanceof IWorldAreaAccessor) {
                IWorldAreaAccessor worldAreaAccessor = (IWorldAreaAccessor)areaAccessor;
                return new WallAreaFilter((Vec3)finalAnchor.get(), currentTarget, (Direction.Axis)finalTargetedAxis.get(), this.extensionWidth);
            }
            return s -> false;
        });
        return ClickProcessingState.ALLOW;
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(IAreaAccessor.class::cast);
    }

    @Override
    public VoxelShape getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return Shapes.m_83040_();
        }
        IWorldAreaMutator mutator = context.getMutator().get();
        Optional<Predicate> filter = context.getStateFilter().map(factory -> (Predicate)factory.apply(mutator));
        if (filter.isEmpty()) {
            return Shapes.m_83040_();
        }
        Predicate stateFilter = filter.get();
        if (!(stateFilter instanceof WallAreaFilter)) {
            return Shapes.m_83040_();
        }
        WallAreaFilter lineAreaFilter = (WallAreaFilter)stateFilter;
        BlockPos offset = VectorUtils.invert(mutator.getInWorldEndBlockPoint());
        List<Vec3i> startPoints = lineAreaFilter.anchors;
        return VoxelShapeUtils.batchCombine(Shapes.m_83040_(), BooleanOp.f_82695_, true, startPoints.stream().map(p -> {
            Vec3i startPointScalar = DrawnWallChiselMode.getOffsetPosition(p, -lineAreaFilter.extensionWidth, lineAreaFilter.axis);
            Vec3i endPointScalar = DrawnWallChiselMode.getOffsetPosition(p, lineAreaFilter.extensionWidth, lineAreaFilter.axis);
            Vec3 startPoint = new Vec3((double)startPointScalar.m_123341_(), (double)startPointScalar.m_123342_(), (double)startPointScalar.m_123343_()).m_82559_(StateEntrySize.current().getSizePerBitScalingVector());
            Vec3 endPoint = new Vec3((double)endPointScalar.m_123341_(), (double)endPointScalar.m_123342_(), (double)endPointScalar.m_123343_()).m_82559_(StateEntrySize.current().getSizePerBitScalingVector());
            Vec3 finalEndpoint = new Vec3(endPoint.m_7096_(), endPoint.m_7098_() + lineAreaFilter.height * (double)StateEntrySize.current().getSizePerBit(), endPoint.m_7094_());
            Vec3 end = finalEndpoint.m_82549_(StateEntrySize.current().getSizePerBitScalingVector());
            Vec3 min = new Vec3(Math.min(startPoint.m_7096_(), end.m_7096_()), Math.min(startPoint.m_7098_(), end.m_7098_()), Math.min(startPoint.m_7094_(), end.m_7094_()));
            Vec3 max = new Vec3(Math.max(startPoint.m_7096_(), end.m_7096_()), Math.max(startPoint.m_7098_(), end.m_7098_()), Math.max(startPoint.m_7094_(), end.m_7094_()));
            return Shapes.m_83048_((double)min.m_7096_(), (double)min.m_7098_(), (double)min.m_7094_(), (double)max.m_7096_(), (double)max.m_7098_(), (double)max.m_7094_());
        }).collect(Collectors.toList())).m_83216_((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_());
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.DRAW);
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public Component getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class WallAreaFilter
    implements Predicate<IStateEntryInfo> {
        private final Vec3i origin;
        private final Vec3 magnitude;
        private final double height;
        private final List<Vec3i> included;
        private final List<Vec3i> anchors;
        private final Direction.Axis axis;
        private final int extensionWidth;

        private WallAreaFilter(Vec3 startPoint, Vec3 endPoint, Direction.Axis axis, int extensionWidth) {
            Vec3 origin = startPoint.m_82559_(StateEntrySize.current().getBitsPerBlockSideScalingVector());
            this.origin = VectorUtils.toInteger(origin.m_7096_(), origin.m_7098_(), origin.m_7094_());
            Vec3 magnitude = endPoint.m_82559_(StateEntrySize.current().getBitsPerBlockSideScalingVector()).m_82546_(origin);
            Vec3i normalizedMagnitude = VectorUtils.toInteger(magnitude.m_7096_(), magnitude.m_7098_(), magnitude.m_7094_());
            this.height = normalizedMagnitude.m_123342_();
            this.magnitude = new Vec3((double)normalizedMagnitude.m_123341_(), 0.0, (double)normalizedMagnitude.m_123343_());
            this.axis = axis;
            this.extensionWidth = extensionWidth;
            this.anchors = this.calculateAnchorPositions();
            this.included = this.calculateIncludedPositions();
        }

        private List<Vec3i> calculateIncludedPositions() {
            return this.anchors.stream().flatMap(i -> {
                Stream.Builder<Vec3i> builder = Stream.builder();
                for (int j = -this.extensionWidth; j <= this.extensionWidth; ++j) {
                    builder.add(DrawnWallChiselMode.getOffsetPosition(i, j, this.axis));
                }
                return builder.build();
            }).collect(Collectors.toList());
        }

        @Override
        public boolean test(IStateEntryInfo stateEntryInfo) {
            if (!(stateEntryInfo instanceof IInWorldStateEntryInfo)) {
                return false;
            }
            IInWorldStateEntryInfo inWorldStateEntryInfo = (IInWorldStateEntryInfo)stateEntryInfo;
            Vec3 pos = inWorldStateEntryInfo.getInWorldStartPoint().m_82559_(StateEntrySize.current().getBitsPerBlockSideScalingVector());
            Vec3i candidatePos = VectorUtils.toInteger(pos.m_7096_(), this.origin.m_123342_(), pos.m_7094_());
            boolean included = this.included.contains(candidatePos);
            if (this.height < 0.0) {
                return included && candidatePos.m_123342_() <= this.origin.m_123342_() && (double)candidatePos.m_123342_() > (double)this.origin.m_123342_() + this.height;
            }
            return included && candidatePos.m_123342_() >= this.origin.m_123342_() && (double)candidatePos.m_123342_() < (double)this.origin.m_123342_() + this.height;
        }

        private List<Vec3i> calculateAnchorPositions() {
            double zDist;
            ArrayList<Vec3i> positions = new ArrayList<Vec3i>();
            Vec3 direction = this.magnitude.m_82541_();
            double xLen = direction.m_82490_(1.0 / direction.m_7096_()).m_82553_();
            double yLen = direction.m_82490_(1.0 / direction.m_7098_()).m_82553_();
            double zLen = direction.m_82490_(1.0 / direction.m_7094_()).m_82553_();
            double reach = this.magnitude.m_82553_();
            double distanceFromStart = 0.0;
            Vec3i pos = new Vec3i((int)(direction.m_7096_() > 0.0 ? Math.ceil(this.origin.m_123341_()) - 1.0 : Math.floor(this.origin.m_123341_())), (int)(direction.m_7098_() > 0.0 ? Math.ceil(this.origin.m_123342_()) - 1.0 : Math.floor(this.origin.m_123342_())), (int)(direction.m_7094_() > 0.0 ? Math.ceil(this.origin.m_123343_()) - 1.0 : Math.floor(this.origin.m_123343_())));
            double xOff = direction.m_7096_() > 0.0 ? (double)(1 + pos.m_123341_() - this.origin.m_123341_()) : (double)(this.origin.m_123341_() - pos.m_123341_());
            double yOff = direction.m_7098_() > 0.0 ? (double)(1 + pos.m_123342_() - this.origin.m_123342_()) : (double)(this.origin.m_123342_() - pos.m_123342_());
            double zOff = direction.m_7094_() > 0.0 ? (double)(1 + pos.m_123343_() - this.origin.m_123343_()) : (double)(this.origin.m_123343_() - pos.m_123343_());
            double xDist = Double.isNaN(xLen) ? Double.POSITIVE_INFINITY : Math.abs(xOff * xLen);
            double yDist = Double.isNaN(yLen) ? Double.POSITIVE_INFINITY : Math.abs(yOff * yLen);
            double d = zDist = Double.isNaN(zLen) ? Double.POSITIVE_INFINITY : Math.abs(zOff * zLen);
            while (distanceFromStart <= reach) {
                positions.add(pos);
                if (xDist < yDist) {
                    if (xDist < zDist) {
                        distanceFromStart = xDist;
                        xDist += xLen;
                        pos = pos.m_7918_(direction.m_7096_() > 0.0 ? 1 : -1, 0, 0);
                        continue;
                    }
                    distanceFromStart = zDist;
                    zDist += zLen;
                    pos = pos.m_7918_(0, 0, direction.m_7094_() > 0.0 ? 1 : -1);
                    continue;
                }
                if (yDist < zDist) {
                    distanceFromStart = yDist;
                    yDist += yLen;
                    pos = pos.m_7918_(0, direction.m_7098_() > 0.0 ? 1 : -1, 0);
                    continue;
                }
                distanceFromStart = zDist;
                zDist += zLen;
                pos = pos.m_7918_(0, 0, direction.m_7094_() > 0.0 ? 1 : -1);
            }
            return positions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WallAreaFilter)) {
                return false;
            }
            WallAreaFilter that = (WallAreaFilter)o;
            if (!this.origin.equals((Object)that.origin)) {
                return false;
            }
            if (!this.magnitude.equals((Object)that.magnitude)) {
                return false;
            }
            return this.included.equals(that.included);
        }

        public int hashCode() {
            int result = this.origin.hashCode();
            result = 31 * result + this.magnitude.hashCode();
            result = 31 * result + this.included.hashCode();
            return result;
        }
    }
}

