/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering.ui.widget;

import de.keksuccino.fancymenu.v3.rendering.DrawableColor;
import de.keksuccino.fancymenu.v3.rendering.RenderingUtils;
import de.keksuccino.fancymenu.v3.rendering.ui.widget.UniqueWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWidget
extends AbstractWidget
implements UniqueWidget {
    @Nullable
    protected String widgetIdentifier;
    @NotNull
    protected TextAlignment alignment = TextAlignment.LEFT;
    @NotNull
    protected DrawableColor baseColor = DrawableColor.WHITE;
    protected boolean shadow = true;
    @NotNull
    protected Font font;

    @NotNull
    public static TextWidget empty(int x, int y, int width) {
        return new TextWidget(x, y, width, 9, Minecraft.m_91087_().f_91062_, (Component)Component.m_237119_());
    }

    @NotNull
    public static TextWidget of(@NotNull Component text, int x, int y, int width) {
        return new TextWidget(x, y, width, 9, Minecraft.m_91087_().f_91062_, text);
    }

    @NotNull
    public static TextWidget of(@NotNull String text, int x, int y, int width) {
        return TextWidget.of((Component)Component.m_237113_((String)text), x, y, width);
    }

    public TextWidget(int x, int y, int width, int height, @NotNull Font font, @NotNull Component text) {
        super(x, y, width, height, text);
        this.font = font;
    }

    public void m_87963_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        int textWidth = this.getTextWidth();
        int textX = this.f_93620_;
        int textY = this.f_93621_;
        if (this.alignment == TextAlignment.CENTER) {
            textX = this.f_93620_ + this.m_5711_() / 2 - textWidth / 2;
        }
        if (this.alignment == TextAlignment.RIGHT) {
            textX = this.f_93620_ + this.m_5711_() - textWidth;
        }
        RenderingUtils.resetShaderColor();
        graphics.m_280614_(this.font, this.m_6035_(), textX, textY, this.baseColor.getColorInt(), this.shadow);
        RenderingUtils.resetShaderColor();
    }

    public int getTextWidth() {
        return this.font.m_92724_(this.m_6035_().m_7532_());
    }

    @NotNull
    public TextAlignment getTextAlignment() {
        return this.alignment;
    }

    public TextWidget setTextAlignment(@NotNull TextAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    @NotNull
    public DrawableColor getBaseColor() {
        return this.baseColor;
    }

    public TextWidget setBaseColor(@NotNull DrawableColor baseColor) {
        this.baseColor = baseColor;
        return this;
    }

    public boolean isShadowEnabled() {
        return this.shadow;
    }

    public TextWidget setShadowEnabled(boolean enabled) {
        this.shadow = enabled;
        return this;
    }

    @NotNull
    public Font getFont() {
        return this.font;
    }

    public TextWidget setFont(@NotNull Font font) {
        this.font = font;
        return this;
    }

    public TextWidget centerWidget(@NotNull Screen parent) {
        this.m_252865_(parent.f_96543_ / 2 - this.m_5711_() / 2);
        return this;
    }

    @Override
    public TextWidget setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.widgetIdentifier = identifier;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.widgetIdentifier;
    }

    protected void m_168797_(@NotNull NarrationElementOutput var1) {
    }

    public static enum TextAlignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

