/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.rendering;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class RenderingUtils {
    public static float getPartialTick() {
        return Minecraft.m_91087_().m_91296_();
    }

    public static boolean isXYInArea(int targetX, int targetY, int x, int y, int width, int height) {
        return RenderingUtils.isXYInArea((double)targetX, (double)targetY, (double)x, (double)y, (double)width, (double)height);
    }

    public static boolean isXYInArea(double targetX, double targetY, double x, double y, double width, double height) {
        return targetX >= x && targetX < x + width && targetY >= y && targetY < y + height;
    }

    public static void resetGuiScale() {
        Window m = Minecraft.m_91087_().m_91268_();
        m.m_85378_((double)m.m_85385_(((Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_()).intValue(), ((Boolean)Minecraft.m_91087_().f_91066_.m_231819_().m_231551_()).booleanValue()));
    }

    public static void resetShaderColor() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void bindTexture(@NotNull ResourceLocation texture, boolean depthTest) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.enableBlend();
        if (depthTest) {
            RenderSystem.enableDepthTest();
        }
    }

    public static void bindTexture(@NotNull ResourceLocation texture) {
        RenderingUtils.bindTexture(texture, false);
    }

    public static int replaceAlphaInColor(int color, int newAlpha) {
        newAlpha = Math.min(newAlpha, 255);
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static int replaceAlphaInColor(int color, float newAlpha) {
        return RenderingUtils.replaceAlphaInColor(color, (int)(newAlpha * 255.0f));
    }

    public static void fillF(@NotNull PoseStack pose, float minX, float minY, float maxX, float maxY, int color) {
        RenderingUtils.fillF(pose, minX, minY, maxX, maxY, 0.0f, color);
    }

    public static void fillF(@NotNull PoseStack pose, float minX, float minY, float maxX, float maxY, float z, int color) {
        Matrix4f matrix4f = pose.m_85850_().m_252922_();
        if (minX < maxX) {
            float $$8 = minX;
            minX = maxX;
            maxX = $$8;
        }
        if (minY < maxY) {
            float $$9 = minY;
            minY = maxY;
            maxY = $$9;
        }
        float red = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float alpha = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix4f, minX, minY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, minX, maxY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, maxY, z).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix4f, maxX, minY, z).m_85950_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void blitF(@NotNull PoseStack pose, float x, float y, float f3, float f4, float width, float height, float width2, float height2) {
        RenderingUtils.blit(pose, x, y, width, height, f3, f4, width, height, width2, height2);
    }

    private static void blit(PoseStack $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10) {
        RenderingUtils.blit($$0, $$1, $$1 + $$3, $$2, $$2 + $$4, 0.0f, $$7, $$8, $$5, $$6, $$9, $$10);
    }

    private static void blit(PoseStack $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9, float $$10, float $$11) {
        RenderingUtils.innerBlit($$0.m_85850_().m_252922_(), $$1, $$2, $$3, $$4, $$5, ($$8 + 0.0f) / $$10, ($$8 + $$6) / $$10, ($$9 + 0.0f) / $$11, ($$9 + $$7) / $$11);
    }

    private static void innerBlit(Matrix4f $$0, float $$1, float $$2, float $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder $$10 = Tesselator.m_85913_().m_85915_();
        $$10.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        $$10.m_252986_($$0, $$1, $$3, $$5).m_7421_($$6, $$8).m_5752_();
        $$10.m_252986_($$0, $$1, $$4, $$5).m_7421_($$6, $$9).m_5752_();
        $$10.m_252986_($$0, $$2, $$4, $$5).m_7421_($$7, $$9).m_5752_();
        $$10.m_252986_($$0, $$2, $$3, $$5).m_7421_($$7, $$8).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)$$10.m_231175_());
    }
}

