/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.v3.input;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CharacterFilter {
    private final List<Character> allowed = new ArrayList<Character>();
    private final List<Character> forbidden = new ArrayList<Character>();

    @NotNull
    public static CharacterFilter buildDoubleCharacterFiler() {
        CharacterFilter f = new CharacterFilter();
        f.addAllowedCharacters("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "-", "+");
        return f;
    }

    @NotNull
    public static CharacterFilter buildIntegerCharacterFiler() {
        CharacterFilter f = new CharacterFilter();
        f.addAllowedCharacters("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "+");
        return f;
    }

    @NotNull
    public static CharacterFilter buildBasicFilenameCharacterFilter() {
        CharacterFilter f = new CharacterFilter();
        f.addAllowedCharacters("a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ".", "_", "-");
        return f;
    }

    @NotNull
    public static CharacterFilter buildFilenameFilterWithUppercaseSupport() {
        CharacterFilter f = CharacterFilter.buildBasicFilenameCharacterFilter();
        f.addAllowedCharacters("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
        return f;
    }

    @NotNull
    public static CharacterFilter buildUrlCharacterFilter() {
        CharacterFilter f = new CharacterFilter();
        f.addAllowedCharacters("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", ".", "-", "_", "~", "+", "#", ",", "%", "&", "=", "*", ";", ":", "@", "?", "/", "\\");
        return f;
    }

    public boolean isAllowedText(@NotNull String text) {
        return this.filterForAllowedChars(text).equals(text);
    }

    public boolean isAllowedChar(char c) {
        if (!this.allowed.isEmpty()) {
            return this.allowed.contains(Character.valueOf(c));
        }
        return !this.forbidden.contains(Character.valueOf(c));
    }

    public boolean isAllowedChar(@NotNull String charAsString) {
        return charAsString.length() < 1 || this.isAllowedChar(charAsString.charAt(0));
    }

    @NotNull
    public String filterForAllowedChars(@NotNull String text) {
        Object s = "";
        for (int i = 0; i < text.length(); ++i) {
            if (!this.isAllowedChar(text.charAt(i))) continue;
            s = (String)s + text.charAt(i);
        }
        return s;
    }

    public void addAllowedCharacters(char ... chars) {
        for (char c : chars) {
            if (this.allowed.contains(Character.valueOf(c))) continue;
            this.allowed.add(Character.valueOf(c));
        }
    }

    public void addAllowedCharacters(String ... chars) {
        for (String s : chars) {
            if (s == null || s.length() < 1 || this.allowed.contains(Character.valueOf(s.charAt(0)))) continue;
            this.allowed.add(Character.valueOf(s.charAt(0)));
        }
    }

    public void addForbiddenCharacters(char ... chars) {
        for (char c : chars) {
            if (this.forbidden.contains(Character.valueOf(c))) continue;
            this.forbidden.add(Character.valueOf(c));
        }
    }

    public void addForbiddenCharacters(String ... chars) {
        for (String s : chars) {
            if (s == null || s.length() < 1 || this.forbidden.contains(Character.valueOf(s.charAt(0)))) continue;
            this.forbidden.add(Character.valueOf(s.charAt(0)));
        }
    }

    @NotNull
    public de.keksuccino.konkrete.input.CharacterFilter convertToLegacyFilter() {
        return new de.keksuccino.konkrete.input.CharacterFilter(){

            public boolean isAllowed(char c) {
                return CharacterFilter.this.isAllowedChar(c);
            }

            public boolean isAllowed(@NotNull String charString) {
                return CharacterFilter.this.isAllowedChar(charString);
            }

            public void addAllowedCharacters(char ... chars) {
                CharacterFilter.this.addAllowedCharacters(chars);
            }

            public void addAllowedCharacters(String ... chars) {
                CharacterFilter.this.addAllowedCharacters(chars);
            }

            public void addForbiddenCharacters(char ... chars) {
                CharacterFilter.this.addForbiddenCharacters(chars);
            }

            public void addForbiddenCharacters(String ... chars) {
                CharacterFilter.this.addForbiddenCharacters(chars);
            }

            public String filterForAllowedChars(@NotNull String text) {
                return CharacterFilter.this.filterForAllowedChars(text);
            }
        };
    }
}

