/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.mixin.client;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.events.SoftMenuReloadEvent;
import de.keksuccino.fancymenu.menu.animation.AnimationHandler;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerBase;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.MenuHandlerRegistry;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.custom.MainMenuHandler;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraftforge.client.event.ScreenEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LoadingOverlay.class})
public abstract class MixinLoadingOverlay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean firstScreenInit = true;
    private MenuHandlerBase menuHandler = null;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructFancyMenu(Minecraft mc, ReloadInstance reloadInstance, Consumer<?> consumer, boolean b, CallbackInfo info) {
        if (((Boolean)FancyMenu.getConfig().getOrDefault("preloadanimations", (Object)true)).booleanValue() && !AnimationHandler.preloadingCompleted()) {
            AnimationHandler.preloadAnimations(false);
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")})
    private void beforeRenderScreenFancyMenu(GuiGraphics graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (this.menuHandler != null && MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_)) {
            this.menuHandler.onRenderPre(new ScreenEvent.Render.Pre(Minecraft.m_91087_().f_91080_, graphics, mouseX, mouseY, partial));
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    private void afterRenderScreenFancyMenu(GuiGraphics graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (this.menuHandler != null && MenuCustomization.isMenuCustomizable(Minecraft.m_91087_().f_91080_)) {
            if (this.menuHandler instanceof MainMenuHandler) {
                Minecraft.m_91087_().f_91080_.m_280273_(graphics);
            }
            this.menuHandler.onRenderPost(new ScreenEvent.Render.Post(Minecraft.m_91087_().f_91080_, graphics, mouseX, mouseY, partial));
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;init(Lnet/minecraft/client/Minecraft;II)V", shift=At.Shift.AFTER)})
    private void afterInitScreenFancyMenu(GuiGraphics graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        if (Minecraft.m_91087_().f_91080_ != null) {
            LOGGER.info("[FANCYMENU] Updating animation sizes..");
            AnimationHandler.updateAnimationSizes();
            this.menuHandler = MenuHandlerRegistry.getHandlerFor(Minecraft.m_91087_().f_91080_);
            if (this.menuHandler != null && firstScreenInit) {
                this.menuHandler.onSoftReload(new SoftMenuReloadEvent(Minecraft.m_91087_().f_91080_));
            }
            firstScreenInit = false;
            MenuCustomization.setIsNewMenu(true);
            MenuCustomization.reInitCurrentScreen();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;setOverlay(Lnet/minecraft/client/gui/screens/Overlay;)V")})
    private void beforeClosingOverlayFancyMenu(GuiGraphics $$0, int $$1, int $$2, float $$3, CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91080_ == null) {
            LOGGER.info("[FANCYMENU] Updating animation sizes..");
            AnimationHandler.updateAnimationSizes();
        }
    }
}

